/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.seqno;

import com.ygsoft.abc.service.seqno.AbstractSequenceNo;
import com.ygsoft.abc.service.tool.BlockCollectionUtil;
import com.ygsoft.abc.service.tool.CastUtil;
import com.ygsoft.ecp.service.dataaccess.ISQLTemplate;
import com.ygsoft.ecp.service.exception.EcpCheckException;
import com.ygsoft.ecp.service.tool.EcpI18nUtil;
import com.ygsoft.ecp.service.tool.OSGiUtil;
import com.ygsoft.ecp.service.tool.StringUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class NoticeCodeBuilder
extends AbstractSequenceNo {
    public static final String TABLE_NAME = "T_NOTICE";
    public static final String FIELD_NAME = "NOTICE_CODE";
    protected String compCode;

    private NoticeCodeBuilder(String table, String field, String prefix, String padding, String compCode) {
        super(table, field, prefix, padding, -1);
        if (StringUtil.isNullOrTrimEmptyString((String)compCode)) {
            throw new EcpCheckException("ABC.0001", EcpI18nUtil.localizedString((String)"NoticeCodeBuilder_NoticeCodeBuilder_47", (String)"\u53c2\u6570\u9519\u8bef\uff1acompCode\u4e3a\u7a7a\u3002"));
        }
        this.compCode = compCode;
    }

    private NoticeCodeBuilder(String table, String field, String prefix, String padding) {
        super(table, field, prefix, padding, -1);
        this.compCode = "";
    }

    private static NoticeCodeBuilder getInstance(String prefix, String compCode) {
        return new NoticeCodeBuilder(TABLE_NAME, FIELD_NAME, prefix, "00000000", compCode);
    }

    private static NoticeCodeBuilder getInstance(String prefix) {
        String prefixWithDate = prefix + AbstractSequenceNo.getYearMonthDay();
        return new NoticeCodeBuilder(TABLE_NAME, FIELD_NAME, prefixWithDate, "00000000");
    }

    public static String getNextCode(String bizName, String compCode) {
        if (StringUtil.isNullOrTrimEmptyString((String)bizName)) {
            throw new EcpCheckException("ABC.0001", EcpI18nUtil.localizedString((String)"NoticeCodeBuilder_getNextCode_88", (String)"\u53c2\u6570\u9519\u8bef\uff1abizName\u4e3a\u7a7a\u3002"));
        }
        if (StringUtil.isNullOrTrimEmptyString((String)compCode)) {
            throw new EcpCheckException("ABC.0001", EcpI18nUtil.localizedString((String)"NoticeCodeBuilder_getNextCode_91", (String)"\u53c2\u6570\u9519\u8bef\uff1acompCode\u4e3a\u7a7a\u3002"));
        }
        String codePrefix = bizName + compCode;
        return NoticeCodeBuilder.getInstance(codePrefix, compCode).getNext();
    }

    public static String getNextCode(String bizName) {
        if (StringUtil.isNullOrTrimEmptyString((String)bizName)) {
            throw new EcpCheckException("ABC.0001", EcpI18nUtil.localizedString((String)"NoticeCodeBuilder_getNextCode_107", (String)"\u53c2\u6570\u9519\u8bef\uff1abizName\u4e3a\u7a7a\u3002"));
        }
        return NoticeCodeBuilder.getInstance(bizName).getNext();
    }

    @Override
    protected long findMaxSeqno() {
        ISQLTemplate sqlTemplate = (ISQLTemplate)OSGiUtil.getSpringBean(ISQLTemplate.class);
        String sql = "SELECT MAX(" + this.field + ") code FROM " + this.table + " WHERE " + this.field + " like :pre";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("pre", this.prefix + "%");
        List list = sqlTemplate.findBySQLWithoutRowNumLimit(sql, param, Map.class);
        if (BlockCollectionUtil.isEmpty(list)) {
            return 0L;
        }
        Map entity = (Map)list.get(0);
        if (null == entity) {
            return 0L;
        }
        String code = CastUtil.getString(entity.get("code"));
        long seqno = CastUtil.getLong(code.substring(this.prefix.length()));
        return seqno;
    }
}

