/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.seqno;

import com.ygsoft.abc.service.seqno.converter.LongConverterFactory;
import com.ygsoft.abc.service.tool.SnowflakeIdWorker;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.IntStream;
import org.apache.commons.lang.StringUtils;

public class BlockGidGenerater {
    private static int PREFIX_LENGTH = 13;
    private static int SUFFIX_LENGTH = 7;
    private static final String PADDING = "0";

    public static String next() {
        long time = System.currentTimeMillis();
        String prefix = BlockGidGenerater.convert(SnowflakeIdWorker.nextId());
        String gid = StringUtils.leftPad((String)prefix, (int)PREFIX_LENGTH, (String)PADDING);
        long end = System.currentTimeMillis();
        System.out.println("gid\u8017\u65f6:" + (end - time));
        return gid + BlockGidGenerater.suffix();
    }

    private static String suffix() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        long val = random.nextLong(10000000L, 900000000L);
        String suffix = StringUtils.leftPad((String)BlockGidGenerater.convert(val), (int)SUFFIX_LENGTH, (String)PADDING);
        return suffix;
    }

    private static String convert(long base10) {
        return LongConverterFactory.base36().convert(base10);
    }

    public static void main(String[] args) {
        IntStream.rangeClosed(1, 100).forEach(idx -> System.out.println(BlockGidGenerater.next()));
        System.out.println(LongConverterFactory.base36().convert(100000L));
        System.out.println(LongConverterFactory.base62().convert(900000000L));
        System.out.println(LongConverterFactory.base36().convert(Long.MAX_VALUE));
        System.out.println(LongConverterFactory.base62().convert(Long.MAX_VALUE));
    }
}

