/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.security.sm4;

import com.ygsoft.abc.service.exception.AbcCryptoException;
import com.ygsoft.abc.service.exception.InvalidValueException;
import com.ygsoft.abc.service.security.sm4.SM4Util;
import com.ygsoft.abc.service.tool.PreconditionUtil;
import org.bouncycastle.pqc.math.linearalgebra.ByteUtils;

public class SM4CBCUtil {
    private static final String HEAD = "{SM4}";
    private static final String HEAD_CBC = "{SM4CBC}";
    private static final byte[] DEFAULT_KEY = new byte[]{1, 35, 69, 103, -119, -85, -51, -17, -2, -36, -70, -104, 118, 84, 50, 16};
    private static final PaddingModeEnum DEFAULT_PADDING = PaddingModeEnum.NoPadding;
    private static final SM4CBCUtil INSTANCE = new SM4CBCUtil(DEFAULT_KEY, DEFAULT_PADDING);
    private final byte[] key;
    final PaddingModeEnum paddingMode;

    private SM4CBCUtil(byte[] key, PaddingModeEnum paddingMode) {
        this.key = key;
        this.paddingMode = paddingMode;
    }

    public static SM4CBCUtil getInstance() {
        return INSTANCE;
    }

    public static SM4CBCUtil getInstance(byte[] key) {
        return new SM4CBCUtil(key, DEFAULT_PADDING);
    }

    public static SM4CBCUtil getInstance(byte[] key, PaddingModeEnum paddingMode) {
        return new SM4CBCUtil(key, paddingMode);
    }

    public static SM4CBCUtil getInstance(String keyHexString) {
        return SM4CBCUtil.getInstance(keyHexString, DEFAULT_PADDING);
    }

    public static SM4CBCUtil getInstance(String keyHexString, PaddingModeEnum paddingMode) {
        byte[] key = ByteUtils.fromHexString((String)keyHexString);
        if (key.length != 16) {
            throw InvalidValueException.newInstance("SM4\u5bc6\u94a5\u683c\u5f0f\u9519\u8bef\u3002");
        }
        return new SM4CBCUtil(key, paddingMode);
    }

    public static byte[] generateKey() {
        try {
            return com.ygsoft.ecp.core.service.encrypt.util.SM4CBCUtil.generateKey();
        }
        catch (Exception e) {
            throw AbcCryptoException.newInstance("SM4\u751f\u6210\u5bc6\u94a5\u5931\u8d25\u3002", e);
        }
    }

    public static String generateKeyHexString() {
        try {
            return com.ygsoft.ecp.core.service.encrypt.util.SM4CBCUtil.generateKeyString();
        }
        catch (Exception e) {
            throw AbcCryptoException.newInstance("SM4\u751f\u6210\u5bc6\u94a5\u5931\u8d25\u3002", e);
        }
    }

    public byte[] encode(byte[] data) {
        return this.encode(data, DEFAULT_KEY);
    }

    public byte[] encode(byte[] data, byte[] key) {
        try {
            if (this.paddingMode == PaddingModeEnum.PKCS5Padding) {
                return com.ygsoft.ecp.core.service.encrypt.util.SM4CBCUtil.encrypt_Cbc_Padding((byte[])key, (byte[])data);
            }
            return com.ygsoft.ecp.core.service.encrypt.util.SM4CBCUtil.encrypt_Cbc_PaddingHex((byte[])key, (byte[])data);
        }
        catch (Exception e) {
            throw AbcCryptoException.newInstance("SM4\u52a0\u5bc6\u5931\u8d25\u3002", e);
        }
    }

    public byte[] encodeSMS4(String plaintext) {
        if (plaintext == null || plaintext.equals("")) {
            return null;
        }
        for (int i = plaintext.getBytes().length % 16; i < 16; ++i) {
            plaintext = plaintext + " ";
        }
        return this.encode(plaintext.getBytes());
    }

    public String encodeWithHeader(String text) {
        if (text == null) {
            return null;
        }
        return HEAD_CBC + SM4Util.byte2hex(this.encodeSMS4(text), true, false);
    }

    public byte[] decode(byte[] cipherData) {
        return this.decode(cipherData, DEFAULT_KEY);
    }

    public byte[] decode(byte[] cipherData, byte[] key) {
        try {
            if (this.paddingMode == PaddingModeEnum.PKCS5Padding) {
                return com.ygsoft.ecp.core.service.encrypt.util.SM4CBCUtil.decrypt_Cbc_Padding((byte[])key, (byte[])cipherData);
            }
            return com.ygsoft.ecp.core.service.encrypt.util.SM4CBCUtil.decrypt_Cbc_PaddingHex((byte[])key, (byte[])cipherData);
        }
        catch (Exception e) {
            throw AbcCryptoException.newInstance("SM4\u89e3\u5bc6\u5931\u8d25\u3002", e);
        }
    }

    public byte[] decode(String cipherText) {
        byte[] cipherData = SM4Util.hex2Bytes(cipherText);
        return this.decode(cipherData);
    }

    public String decodeWithHeader(String cipherText) {
        if (cipherText == null) {
            return null;
        }
        if (cipherText.startsWith(HEAD_CBC)) {
            String str = cipherText.substring(HEAD_CBC.length());
            byte[] decodeData = this.decode(str);
            return new String(decodeData).trim();
        }
        if (cipherText.startsWith(HEAD)) {
            return SM4Util.decodeSM4Str(cipherText);
        }
        return cipherText;
    }

    public static boolean startWithHeader(String str) {
        PreconditionUtil.checkNotNull(str, "\u53c2\u6570\u9519\u8bef\uff1astr\u4e3a\u7a7a\u3002");
        return str.startsWith(HEAD_CBC);
    }

    public static void main(String[] args) {
        System.out.println("\u52a0\u5bc6:" + SM4CBCUtil.getInstance().encodeWithHeader("\u6c49\u5b57\u5462\u51e0\u4e2a\u5b50"));
        System.out.println("{SM4CBC}\u89e3\u5bc6:" + SM4CBCUtil.getInstance().decodeWithHeader("{SM4CBC}9DE988B90C7ABC2DA245B4B45D6C84E35CD341C55C431868D4D925A5C5E91DB8"));
        String keyHexString = SM4CBCUtil.generateKeyHexString();
        System.out.println("\u5bc6\u94a5\uff1a" + keyHexString);
        System.out.println("\u52a0\u5bc6:" + SM4CBCUtil.getInstance(keyHexString, PaddingModeEnum.PKCS5Padding).encodeWithHeader("abc\u6c49\u5b57\u5462\u51e0\u4e2a\u5b50"));
        System.out.println("{SM4CBC}\u89e3\u5bc6:" + SM4CBCUtil.getInstance(keyHexString, PaddingModeEnum.PKCS5Padding).decodeWithHeader("{SM4CBC}44D8B9A383647B21CE776BFEA6C88A36B18358A3595B4B1B2396809073B0A9DCEBFCD8062DCE0EAD4BA078CC51C4C262"));
        System.out.println("{SM4}\u89e3\u5bc6\uff1a" + SM4CBCUtil.getInstance().decodeWithHeader("{SM4}E72A07699FA0824D911D5CB904C04E013C17F1A02E609C2237DD5C51B6E7388C"));
    }

    public static enum PaddingModeEnum {
        PKCS5Padding,
        NoPadding;

    }
}

