/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.security.kit;

import com.google.common.collect.ImmutableSet;
import com.ygsoft.abc.service.exception.AbcCryptoException;
import com.ygsoft.abc.service.exception.InvalidValueException;
import com.ygsoft.abc.service.security.key.kit.KeyPairKit;
import com.ygsoft.abc.service.security.kit.Base64Kit;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Set;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class SignatureKit {
    public static ISignature rsa() {
        return new RSASignature();
    }

    public static ISignature rsa(String signatureAlgorithm) {
        return new RSASignature(signatureAlgorithm);
    }

    public static ISignature dsa() {
        return new DSASignature();
    }

    public static ISignature dsa(String signatureAlgorithm) {
        return new DSASignature(signatureAlgorithm);
    }

    public static ISignature ecdsa() {
        return new ECDSASignature();
    }

    public static ISignature ecdsa(String signatureAlgorithm) {
        return new ECDSASignature(signatureAlgorithm);
    }

    public static void main(String[] args) {
        String data = "\u9762\u671d\u5927\u6d77\uff0c\u6625\u6696\u82b1\u5f00\u3002";
        KeyPair keyPair = KeyPairKit.rsa(2048).generate();
        byte[] signed = SignatureKit.rsa("SHA256withRSA").sign("\u9762\u671d\u5927\u6d77\uff0c\u6625\u6696\u82b1\u5f00\u3002".getBytes(), keyPair.getPrivate().getEncoded());
        System.out.println("RSA\u52a0\u7b7e\u540e\uff1a" + Base64Kit.standardMode().encode(signed));
        boolean success = SignatureKit.rsa("SHA256withRSA").verify("\u9762\u671d\u5927\u6d77\uff0c\u6625\u6696\u82b1\u5f00\u3002".getBytes(), keyPair.getPublic().getEncoded(), signed);
        System.out.println("RSA\u9a8c\u7b7e\u6210\u529f\uff1a" + success);
        System.out.println("------------------\u534e\u4e3d\u7684\u5206\u5272\u7ebf------------------");
        keyPair = KeyPairKit.dsa().generate();
        signed = SignatureKit.dsa("SHA256withDSA").sign("\u9762\u671d\u5927\u6d77\uff0c\u6625\u6696\u82b1\u5f00\u3002".getBytes(), keyPair.getPrivate().getEncoded());
        System.out.println("DSA\u52a0\u7b7e\u540e\uff1a" + Base64Kit.standardMode().encode(signed));
        success = SignatureKit.dsa("SHA256withDSA").verify("\u9762\u671d\u5927\u6d77\uff0c\u6625\u6696\u82b1\u5f00\u3002".getBytes(), keyPair.getPublic().getEncoded(), signed);
        System.out.println("DSA\u9a8c\u7b7e\u6210\u529f\uff1a" + success);
        System.out.println("------------------\u534e\u4e3d\u7684\u5206\u5272\u7ebf------------------");
        keyPair = KeyPairKit.ecdsa().generate();
        signed = SignatureKit.ecdsa().sign("\u9762\u671d\u5927\u6d77\uff0c\u6625\u6696\u82b1\u5f00\u3002".getBytes(), keyPair.getPrivate().getEncoded());
        System.out.println("ECDSA\u52a0\u7b7e\u540e\uff1a" + Base64Kit.standardMode().encode(signed));
        success = SignatureKit.ecdsa().verify("\u9762\u671d\u5927\u6d77\uff0c\u6625\u6696\u82b1\u5f00\u3002".getBytes(), keyPair.getPublic().getEncoded(), signed);
        System.out.println("ECDSA\u9a8c\u7b7e\u6210\u529f\uff1a" + success);
    }

    static class ECDSASignature
    implements ISignature {
        private static final String KEY_ALGORITHM = "ECDSA";
        private static final String SIGNATURE_ALGORITHM = "SHA1withECDSA";
        private static final Set<String> ACCEPT_ALGORITHMS = ImmutableSet.of((Object)"NONEwithECDSA", (Object)"RIPEMD160withECDSA", (Object)"SHA1withECDSA", (Object)"SHA224withECDSA", (Object)"SHA256withECDSA", (Object)"SHA384withECDSA", (Object[])new String[]{"SHA512withECDSA"});
        private final String signatureAlgorithm;

        public ECDSASignature() {
            this(SIGNATURE_ALGORITHM);
        }

        public ECDSASignature(String signatureAlgorithm) {
            if (!ACCEPT_ALGORITHMS.contains(signatureAlgorithm)) {
                throw InvalidValueException.newInstance("\u4e0d\u63a5\u53d7\u7684\u7b7e\u540d\u7b97\u6cd5\uff08" + signatureAlgorithm + "\uff09\u3002");
            }
            this.signatureAlgorithm = signatureAlgorithm;
        }

        @Override
        public byte[] sign(byte[] data, byte[] privateKey) {
            Security.addProvider((Provider)new BouncyCastleProvider());
            try {
                PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(privateKey);
                KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
                PrivateKey priKey = keyFactory.generatePrivate(pkcs8KeySpec);
                Signature signature = Signature.getInstance(this.signatureAlgorithm);
                signature.initSign(priKey);
                signature.update(data);
                return signature.sign();
            }
            catch (Exception e) {
                throw AbcCryptoException.newInstance("\u52a0\u7b7e\u5931\u8d25\u3002", e);
            }
        }

        @Override
        public boolean verify(byte[] data, byte[] publicKey, byte[] sign) {
            Security.addProvider((Provider)new BouncyCastleProvider());
            try {
                X509EncodedKeySpec keySpec = new X509EncodedKeySpec(publicKey);
                KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
                PublicKey pubKey = keyFactory.generatePublic(keySpec);
                Signature signature = Signature.getInstance(this.signatureAlgorithm);
                signature.initVerify(pubKey);
                signature.update(data);
                return signature.verify(sign);
            }
            catch (Exception e) {
                throw AbcCryptoException.newInstance("\u9a8c\u7b7e\u5931\u8d25\u3002", e);
            }
        }
    }

    static class DSASignature
    implements ISignature {
        private static final String KEY_ALGORITHM = "DSA";
        private static final String SIGNATURE_ALGORITHM = "SHA1withDSA";
        private static final Set<String> ACCEPT_ALGORITHMS = ImmutableSet.of((Object)"SHA1withDSA", (Object)"SHA224withDSA", (Object)"SHA256withDSA", (Object)"SHA384withDSA", (Object)"SHA512withDSA");
        private final String signatureAlgorithm;

        public DSASignature() {
            this(SIGNATURE_ALGORITHM);
        }

        public DSASignature(String signatureAlgorithm) {
            if (!ACCEPT_ALGORITHMS.contains(signatureAlgorithm)) {
                throw InvalidValueException.newInstance("\u4e0d\u63a5\u53d7\u7684\u7b7e\u540d\u7b97\u6cd5\uff08" + signatureAlgorithm + "\uff09\u3002");
            }
            this.signatureAlgorithm = signatureAlgorithm;
        }

        @Override
        public byte[] sign(byte[] data, byte[] privateKey) {
            Security.addProvider((Provider)new BouncyCastleProvider());
            try {
                PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(privateKey);
                KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
                PrivateKey priKey = keyFactory.generatePrivate(pkcs8KeySpec);
                Signature signature = Signature.getInstance(this.signatureAlgorithm);
                signature.initSign(priKey);
                signature.update(data);
                return signature.sign();
            }
            catch (Exception e) {
                throw AbcCryptoException.newInstance("\u52a0\u7b7e\u5931\u8d25\u3002", e);
            }
        }

        @Override
        public boolean verify(byte[] data, byte[] publicKey, byte[] sign) {
            Security.addProvider((Provider)new BouncyCastleProvider());
            try {
                X509EncodedKeySpec keySpec = new X509EncodedKeySpec(publicKey);
                KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
                PublicKey pubKey = keyFactory.generatePublic(keySpec);
                Signature signature = Signature.getInstance(this.signatureAlgorithm);
                signature.initVerify(pubKey);
                signature.update(data);
                return signature.verify(sign);
            }
            catch (Exception e) {
                throw AbcCryptoException.newInstance("\u9a8c\u7b7e\u5931\u8d25\u3002", e);
            }
        }
    }

    static class RSASignature
    implements ISignature {
        private static final String KEY_ALGORITHM = "RSA";
        private static final String SIGNATURE_ALGORITHM = "SHA1withRSA";
        private static final Set<String> ACCEPT_ALGORITHMS = ImmutableSet.of((Object)"MD2withRSA", (Object)"MD5withRSA", (Object)"SHA1withRSA", (Object)"SHA224withRSA", (Object)"SHA256withRSA", (Object)"SHA384withRSA", (Object[])new String[]{"SHA512withRSA", "RIPEMD128withRSA", "RIPEMD160withRSA"});
        private final String signatureAlgorithm;

        public RSASignature() {
            this(SIGNATURE_ALGORITHM);
        }

        public RSASignature(String signatureAlgorithm) {
            if (!ACCEPT_ALGORITHMS.contains(signatureAlgorithm)) {
                throw InvalidValueException.newInstance("\u4e0d\u63a5\u53d7\u7684\u7b7e\u540d\u7b97\u6cd5\uff08" + signatureAlgorithm + "\uff09\u3002");
            }
            this.signatureAlgorithm = signatureAlgorithm;
        }

        @Override
        public byte[] sign(byte[] data, byte[] privateKey) {
            Security.addProvider((Provider)new BouncyCastleProvider());
            try {
                PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(privateKey);
                KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
                PrivateKey priKey = keyFactory.generatePrivate(pkcs8KeySpec);
                Signature signature = Signature.getInstance(this.signatureAlgorithm);
                signature.initSign(priKey);
                signature.update(data);
                return signature.sign();
            }
            catch (Exception e) {
                throw AbcCryptoException.newInstance("\u52a0\u7b7e\u5931\u8d25\u3002", e);
            }
        }

        @Override
        public boolean verify(byte[] data, byte[] publicKey, byte[] sign) {
            Security.addProvider((Provider)new BouncyCastleProvider());
            try {
                X509EncodedKeySpec keySpec = new X509EncodedKeySpec(publicKey);
                KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
                PublicKey pubKey = keyFactory.generatePublic(keySpec);
                Signature signature = Signature.getInstance(this.signatureAlgorithm);
                signature.initVerify(pubKey);
                signature.update(data);
                return signature.verify(sign);
            }
            catch (Exception e) {
                throw AbcCryptoException.newInstance("\u9a8c\u7b7e\u5931\u8d25\u3002", e);
            }
        }
    }

    public static interface ISignature {
        public byte[] sign(byte[] var1, byte[] var2);

        public boolean verify(byte[] var1, byte[] var2, byte[] var3);
    }
}

