/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.security.kit;

import com.google.common.io.BaseEncoding;
import java.nio.charset.Charset;

public final class HexKit {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final HexKit INSTANCE = new HexKit();

    private HexKit() {
    }

    public static HexKit getInstance() {
        return INSTANCE;
    }

    public String encode(byte[] bytes) {
        return BaseEncoding.base16().encode(bytes);
    }

    public String encode(String str) {
        return this.encode(str.getBytes(UTF_8));
    }

    public byte[] decode(CharSequence charSequence) {
        return BaseEncoding.base16().decode(charSequence);
    }

    public String decodeToString(CharSequence charSequence) {
        return new String(this.decode(charSequence), UTF_8);
    }

    public static void main(String[] args) {
        String str = "abc\u662f\u5426\u554a\u554a\uff01\uff20\uff01\uff20\uff03\uff20\uff03\uffe5\uff03\uffe5\u5361\u770b\u5230\u4e86~!\u5361\u592b\u5361@#$%^&*(((\u770b\u770b\u770b;....";
        String encode1 = HexKit.getInstance().encode("abc\u662f\u5426\u554a\u554a\uff01\uff20\uff01\uff20\uff03\uff20\uff03\uffe5\uff03\uffe5\u5361\u770b\u5230\u4e86~!\u5361\u592b\u5361@#$%^&*(((\u770b\u770b\u770b;....".getBytes());
        System.out.println("16\u7f16\u7801\u540e\uff1a" + encode1);
        byte[] decode1 = HexKit.getInstance().decode(encode1);
        System.out.println("16\u89e3\u7801\u540e\uff1a" + new String(decode1));
    }
}

