/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.security.kit;

import com.google.common.collect.ImmutableSet;
import com.ygsoft.abc.service.exception.AbcCryptoException;
import com.ygsoft.abc.service.exception.InvalidValueException;
import com.ygsoft.abc.service.security.domain.bo.X509CertWithPrivateKey;
import com.ygsoft.abc.service.tool.BlockIOUtil;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Set;

public class CertificateKit {
    private static final String CERT_TYPE = "X.509";

    public static ICertificateSingle cer() {
        return new CertificateSingle();
    }

    public static IPfxCertificate pfx() {
        return new PfxCertificate();
    }

    public static KeyStore getKeyStore(byte[] data, String storeType, String password) {
        try {
            KeyStore ks = KeyStore.getInstance(storeType);
            ks.load(BlockIOUtil.toInputStream(data), password.toCharArray());
            return ks;
        }
        catch (Exception e) {
            throw AbcCryptoException.newInstance("KeyStore\u521d\u59cb\u5316\u5931\u8d25\u3002", e);
        }
    }

    public static String getAlias(KeyStore ks) {
        try {
            Enumeration<String> enumas = ks.aliases();
            String alias = null;
            if (enumas.hasMoreElements()) {
                alias = enumas.nextElement();
                System.out.println("alias=" + alias);
            }
            return alias;
        }
        catch (Exception e) {
            throw AbcCryptoException.newInstance("\u8bfb\u53d6alias\u5931\u8d25\u3002", e);
        }
    }

    public static void main(String[] args) {
        byte[] certData = BlockIOUtil.readBytes("file:D:/data/certs/alipayCertPublicKey_RSA2.crt");
        X509Certificate cert = CertificateKit.cer().getCert(certData);
        System.out.println(cert.getSigAlgName());
        byte[] keyStoreData = BlockIOUtil.readBytes("file:D:/data/certs/zlex.keystore");
        CertificateKit.cer().getPrivateKey(keyStoreData, "123456");
        System.out.println("------------------\u534e\u4e3d\u7684\u5206\u5272\u7ebf------------------");
        certData = BlockIOUtil.readBytes("file:D:/data/certs/\u91d1\u5fc5\u8fbe123456.pfx");
        CertificateKit.pfx().getCertDetail(certData, "123456");
    }

    static class PfxCertificate
    implements IPfxCertificate {
        private static final String STORE_TYPE = "PKCS12";

        PfxCertificate() {
        }

        @Override
        public X509CertWithPrivateKey getCertDetail(byte[] certData, String password) {
            try {
                KeyStore ks = CertificateKit.getKeyStore(certData, STORE_TYPE, password);
                System.out.println("keystore type=" + ks.getType());
                String keyAlias = CertificateKit.getAlias(ks);
                System.out.println("is key entry=" + ks.isKeyEntry(keyAlias));
                PrivateKey privateKey = (PrivateKey)ks.getKey(keyAlias, password.toCharArray());
                Certificate cert = ks.getCertificate(keyAlias);
                Certificate[] chain = ks.getCertificateChain(keyAlias);
                return new X509CertWithPrivateKey((X509Certificate)cert, privateKey, chain);
            }
            catch (Exception e) {
                throw AbcCryptoException.newInstance("\u8bfb\u53d6\u8bc1\u4e66\u5931\u8d25\u3002", e);
            }
        }
    }

    static class CertificateSingle
    implements ICertificateSingle {
        private static final Set<String> ACCEPT_STORE_TYPES = ImmutableSet.of((Object)"JKS", (Object)"PKCS12");

        CertificateSingle() {
        }

        @Override
        public X509Certificate getCert(byte[] certData) {
            try {
                CertificateFactory certFactory = CertificateFactory.getInstance(CertificateKit.CERT_TYPE);
                Certificate certificate = certFactory.generateCertificate(BlockIOUtil.toInputStream(certData));
                return (X509Certificate)certificate;
            }
            catch (Exception e) {
                throw AbcCryptoException.newInstance("\u8bfb\u53d6\u8bc1\u4e66\u5931\u8d25\u3002", e);
            }
        }

        @Override
        public PrivateKey getPrivateKey(byte[] keyStoreData, String password) {
            return this.getPrivateKey(KeyStore.getDefaultType(), keyStoreData, password);
        }

        @Override
        public PrivateKey getPrivateKey(String storeType, byte[] keyStoreData, String password) {
            if (!this.contains(storeType)) {
                throw InvalidValueException.newInstance("\u4e0d\u63a5\u53d7\u7684storeType\uff08" + storeType + "\uff09\u3002");
            }
            try {
                KeyStore keyStore = CertificateKit.getKeyStore(keyStoreData, storeType, password);
                String alias = CertificateKit.getAlias(keyStore);
                return (PrivateKey)keyStore.getKey(alias, password.toCharArray());
            }
            catch (Exception e) {
                throw AbcCryptoException.newInstance("\u8bfb\u53d6\u8bc1\u4e66\u5931\u8d25\u3002", e);
            }
        }

        private boolean contains(String storeType) {
            for (String accept : ACCEPT_STORE_TYPES) {
                if (!accept.equalsIgnoreCase(storeType)) continue;
                return true;
            }
            return false;
        }
    }

    public static interface IPfxCertificate {
        public X509CertWithPrivateKey getCertDetail(byte[] var1, String var2);
    }

    public static interface ICertificateSingle {
        public X509Certificate getCert(byte[] var1);

        public PrivateKey getPrivateKey(byte[] var1, String var2);

        public PrivateKey getPrivateKey(String var1, byte[] var2, String var3);
    }
}

