/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.security;

import com.ygsoft.abc.service.exception.AbcCryptoException;
import com.ygsoft.ecp.service.tool.UuidUtil;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.HashMap;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AESUtil {
    private static final String CHARSET_UTF8 = "UTF-8";
    private static final String AES_NAME = "AES";
    private static final String AES_ALGORITHM = "AES/CBC/PKCS5Padding";

    public static String buildKey() {
        try {
            String uuid = UuidUtil.newUUID();
            String aesKey = Base64.getEncoder().encodeToString(uuid.getBytes()).substring(2, 18);
            return aesKey;
        }
        catch (Exception ex) {
            throw new AbcCryptoException("ABC.0032", ex);
        }
    }

    public static String buildIv() {
        try {
            String uuid = UuidUtil.newUUID();
            String iv = Base64.getEncoder().encodeToString(uuid.getBytes()).substring(2, 18);
            return iv;
        }
        catch (Exception ex) {
            throw new AbcCryptoException("ABC.0032", ex);
        }
    }

    public static HashMap<String, String> buildKeyAndIv() {
        HashMap<String, String> aesKeyAndIv = new HashMap<String, String>();
        aesKeyAndIv.put("key", AESUtil.buildKey());
        aesKeyAndIv.put("iv", AESUtil.buildIv());
        return aesKeyAndIv;
    }

    public static String encryptByBuild(byte[] content, String secretKeyStr, String iv) {
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(secretKeyStr.getBytes(), AES_NAME);
            Cipher cipher = Cipher.getInstance(AES_ALGORITHM);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(iv.getBytes());
            cipher.init(1, (Key)secretKeySpec, ivParameterSpec);
            return Base64.getEncoder().encodeToString(cipher.doFinal(content));
        }
        catch (Exception ex) {
            throw new AbcCryptoException("ABC.0032", ex);
        }
    }

    public static String decryptByBuild(byte[] content, String secretKeyStr, String iv) {
        try {
            byte[] contentDecByBase64 = Base64.getDecoder().decode(content);
            SecretKeySpec secretKeySpec = new SecretKeySpec(secretKeyStr.getBytes(), AES_NAME);
            Cipher cipher = Cipher.getInstance(AES_ALGORITHM);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(iv.getBytes());
            cipher.init(2, (Key)secretKeySpec, ivParameterSpec);
            return new String(cipher.doFinal(contentDecByBase64), CHARSET_UTF8);
        }
        catch (Exception ex) {
            throw new AbcCryptoException("ABC.0032", ex);
        }
    }

    private static String formatIv(String iv) {
        if (iv.length() > 16) {
            return iv.substring(0, 16);
        }
        int length = 16 - iv.length();
        StringBuilder sb = new StringBuilder(iv);
        for (int i = 0; i < length; ++i) {
            sb.append("0");
        }
        return sb.toString();
    }

    private static SecretKey generateKey(String keyStr) {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(AES_NAME);
            keyGenerator.init(128, new SecureRandom(keyStr.getBytes()));
            SecretKey key = keyGenerator.generateKey();
            return key;
        }
        catch (Exception ex) {
            throw new AbcCryptoException("ABC.0032", ex);
        }
    }

    public static String encrypt(byte[] content, String keyStr, String iv) {
        try {
            Cipher cipher = Cipher.getInstance(AES_ALGORITHM);
            cipher.init(1, (Key)AESUtil.generateKey(keyStr), new IvParameterSpec(AESUtil.formatIv(iv).getBytes()));
            return Base64.getEncoder().encodeToString(cipher.doFinal(content));
        }
        catch (Exception ex) {
            throw new AbcCryptoException("ABC.0032", ex);
        }
    }

    public static byte[] encryptBytes(byte[] content, String keyStr, String iv) {
        try {
            Cipher cipher = Cipher.getInstance(AES_ALGORITHM);
            cipher.init(1, (Key)AESUtil.generateKey(keyStr), new IvParameterSpec(AESUtil.formatIv(iv).getBytes()));
            return cipher.doFinal(content);
        }
        catch (Exception ex) {
            throw new AbcCryptoException("ABC.0032", ex);
        }
    }

    public static String decrypt(byte[] content, String keyStr, String iv) {
        try {
            Cipher cipher = Cipher.getInstance(AES_ALGORITHM);
            cipher.init(2, (Key)AESUtil.generateKey(keyStr), new IvParameterSpec(AESUtil.formatIv(iv).getBytes()));
            byte[] contentDecByBase64 = Base64.getDecoder().decode(content);
            return new String(cipher.doFinal(contentDecByBase64), CHARSET_UTF8);
        }
        catch (Exception ex) {
            throw new AbcCryptoException("ABC.0032", ex);
        }
    }

    public static byte[] decryptBytes(byte[] content, String keyStr, String iv) {
        try {
            Cipher cipher = Cipher.getInstance(AES_ALGORITHM);
            cipher.init(2, (Key)AESUtil.generateKey(keyStr), new IvParameterSpec(AESUtil.formatIv(iv).getBytes()));
            return cipher.doFinal(content);
        }
        catch (Exception ex) {
            throw new AbcCryptoException("ABC.0032", ex);
        }
    }
}

