/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.http.kit;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.ygsoft.abc.service.attachment.io.ByteArrayMultipartFile;
import com.ygsoft.abc.service.attachment.io.StreamMultipartFile;
import com.ygsoft.abc.service.exception.AbcServiceException;
import com.ygsoft.abc.service.exception.EmptyValueException;
import com.ygsoft.abc.service.exception.HttpCallException;
import com.ygsoft.abc.service.exception.HttpClientException;
import com.ygsoft.abc.service.http.domain.vo.HttpByteArrayRespVO;
import com.ygsoft.abc.service.http.domain.vo.HttpResponseVO;
import com.ygsoft.abc.service.http.domain.vo.HttpStreamRespVO;
import com.ygsoft.abc.service.http.domain.vo.HttpTextRespVO;
import com.ygsoft.abc.service.http.kit.HttpClientInitParam;
import com.ygsoft.abc.service.tool.BlockCodingUtil;
import com.ygsoft.abc.service.tool.BlockCollectionUtil;
import com.ygsoft.abc.service.tool.BlockIOUtil;
import com.ygsoft.ecp.core.framework.internal.context.LoginContext;
import com.ygsoft.ecp.mapp.common.service.util.LoginContextUtil;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public final class HttpClientKit {
    private static final IEcpLog LOG = EcpLogFactory.getLog(HttpClientKit.class);
    private PoolingHttpClientConnectionManager gcm = null;
    private CloseableHttpClient httpClient = null;
    private IdleConnectionMonitorThread idleThread = null;
    private final HttpClientInitParam initParam;
    private final boolean hasEcpToken;
    private static Map<String, String> JSON_HEADER = ImmutableMap.of((Object)"Accept", (Object)"application/json", (Object)"Content-Type", (Object)"application/json;charset=UTF-8");
    private static Map<String, String> STREAM_HEADER = ImmutableMap.of((Object)"Accept", (Object)"application/octet-stream", (Object)"Content-Type", (Object)"application/octet-stream");
    private static Map<String, String> FORM_HEADER = ImmutableMap.of((Object)"Accept", (Object)"application/json", (Object)"Content-Type", (Object)"application/x-www-form-urlencoded;charset=utf-8");

    public static final HttpClientKit getInstance() {
        return HttpClientKit.getInstance(HttpClientInitParam.getInstance(), false);
    }

    public static final HttpClientKit getInstance(boolean hasEcpToken) {
        return HttpClientKit.getInstance(HttpClientInitParam.getInstance(), hasEcpToken);
    }

    public static final HttpClientKit getInstance(HttpClientInitParam initParam, boolean hasEcpToken) {
        HttpClientKit client = new HttpClientKit(initParam, hasEcpToken);
        return client;
    }

    private HttpClientKit() {
        this(HttpClientInitParam.getInstance(), false);
    }

    private HttpClientKit(HttpClientInitParam initParam, boolean hasEcpToken) {
        this.initParam = initParam;
        this.hasEcpToken = hasEcpToken;
        Registry registry = RegistryBuilder.create().register("http", (Object)this.initParam.getHttpConnectSocketFactory()).register("https", (Object)this.initParam.getHttpsConnectSocketFactory()).build();
        this.gcm = new PoolingHttpClientConnectionManager(registry);
        this.gcm.setMaxTotal(this.initParam.getMaxTotal());
        this.gcm.setDefaultMaxPerRoute(this.initParam.getMaxPerRoute());
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(this.initParam.getConnectRequestTimeout()).setSocketTimeout(this.initParam.getConnectTimeout()).setConnectionRequestTimeout(this.initParam.getConnectRequestTimeout()).build();
        HttpClientBuilder httpClientBuilder = HttpClients.custom();
        this.httpClient = httpClientBuilder.setConnectionManager((HttpClientConnectionManager)this.gcm).setDefaultRequestConfig(requestConfig).build();
        this.idleThread = new IdleConnectionMonitorThread((HttpClientConnectionManager)this.gcm);
        this.idleThread.start();
    }

    private HttpEntity getUrlEncodedFormEntity(Map<String, Object> params) {
        ArrayList<BasicNameValuePair> pairList = new ArrayList<BasicNameValuePair>(params.size());
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            BasicNameValuePair basicNameValuePair = new BasicNameValuePair(entry.getKey(), entry.getValue().toString());
            pairList.add(basicNameValuePair);
        }
        return new UrlEncodedFormEntity(pairList, Charset.forName("UTF-8"));
    }

    private String getUrlWithParams(String url, Map<String, Object> params) {
        boolean first = true;
        StringBuilder sb = new StringBuilder(url);
        if (params != null) {
            for (String key : params.keySet()) {
                char ch = '&';
                if (first) {
                    ch = '?';
                    first = false;
                }
                String value = params.get(key).toString();
                try {
                    String sval = URLEncoder.encode(value, "UTF-8");
                    sb.append(ch).append(key).append("=").append(sval);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            }
        }
        return sb.toString();
    }

    public HttpTextRespVO doGet(String url) {
        return this.doGet(url, null, null);
    }

    public HttpTextRespVO doGet(String url, Map<String, String> headers) {
        return this.doGet(url, headers, null);
    }

    private Map<String, List<String>> parserHeader(HttpResponse response) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        Header[] responseHeaders = response.getAllHeaders();
        if (responseHeaders != null) {
            for (Header h : responseHeaders) {
                String key = h.getName();
                if (map.containsKey(key)) {
                    ((List)map.get(key)).add(h.getValue());
                    continue;
                }
                ArrayList<String> list = new ArrayList<String>();
                list.add(h.getValue());
                map.put(key, list);
            }
        }
        return map;
    }

    private String parseFileName(HttpResponseVO<?> result) {
        List<String> list = result.getHeader().get("file-name");
        if (!BlockCollectionUtil.isEmpty(list)) {
            return BlockCodingUtil.decodeUrl(list.get(0));
        }
        List<String> list2 = result.getHeader().get("content-disposition");
        if (BlockCollectionUtil.isEmpty(list2)) {
            throw EmptyValueException.newInstance("\u54cd\u5e94\u5934\u672a\u8bbe\u7f6efile-name\u5c5e\u6027\u3002");
        }
        Optional<String> fileNameStr = list2.stream().filter(it -> it.indexOf("filename=") > -1).findFirst();
        if (!fileNameStr.isPresent()) {
            throw EmptyValueException.newInstance("\u54cd\u5e94\u5934\u672a\u8bbe\u7f6efile-name\u5c5e\u6027\u3002");
        }
        String s = fileNameStr.get();
        String fileName = s.substring(s.indexOf("filename=") + "filename=".length());
        if (Strings.isNullOrEmpty((String)fileName)) {
            throw EmptyValueException.newInstance("\u54cd\u5e94\u5934\u672a\u8bbe\u7f6efile-name\u5c5e\u6027\u3002");
        }
        return BlockCodingUtil.decodeUrl(fileName);
    }

    private Header[] buildHeaders(Map<String, String> headers, Map<String, String> defaultHeader) {
        ArrayList<BasicHeader> list = new ArrayList<BasicHeader>();
        if (headers == null || headers.size() == 0) {
            for (Map.Entry<String, String> entry : defaultHeader.entrySet()) {
                BasicHeader header = new BasicHeader(entry.getKey(), entry.getValue());
                list.add(header);
            }
            return list.toArray(new Header[0]);
        }
        for (Map.Entry<String, String> entry : defaultHeader.entrySet()) {
            if (headers.containsKey(entry.getKey())) continue;
            headers.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            BasicHeader header = new BasicHeader(entry.getKey(), entry.getValue());
            list.add(header);
        }
        if (this.hasEcpToken) {
            LoginContext loginContext = (LoginContext)LoginContextUtil.getLoginContext();
            list.add(new BasicHeader("ecp_token", loginContext.getTokenId()));
            list.add(new BasicHeader("ecpDataContext.tokenId", loginContext.getTokenId()));
        }
        return list.toArray(new Header[0]);
    }

    public HttpTextRespVO doGet(String url, Map<String, String> headers, Map<String, Object> params) {
        String apiUrl = this.getUrlWithParams(url, params);
        HttpGet httpGet = new HttpGet(apiUrl);
        httpGet.setHeaders(this.buildHeaders(headers, JSON_HEADER));
        try {
            HttpTextRespVO resp = (HttpTextRespVO)this.httpClient.execute((HttpUriRequest)httpGet, (ResponseHandler)new TextResponseHandler());
            return resp;
        }
        catch (Exception e) {
            throw HttpClientException.newInstance(e);
        }
    }

    public void doGetWithConsumer(String url, Consumer<HttpResponse> consumer) {
        this.doGetWithConsumer(url, null, null, consumer);
    }

    public void doGetWithConsumer(String url, Map<String, String> headers, Consumer<HttpResponse> consumer) {
        this.doGetWithConsumer(url, headers, null, consumer);
    }

    public void doGetWithConsumer(String url, Map<String, String> headers, Map<String, Object> params, Consumer<HttpResponse> consumer) {
        String apiUrl = this.getUrlWithParams(url, params);
        HttpGet httpGet = new HttpGet(apiUrl);
        httpGet.setHeaders(this.buildHeaders(headers, JSON_HEADER));
        try {
            HttpTextRespVO resp = (HttpTextRespVO)this.httpClient.execute((HttpUriRequest)httpGet, (ResponseHandler)new CustomResponseHandler(consumer));
            if (LOG.isInfoEnabled()) {
                LOG.info(resp.getEntity());
            }
        }
        catch (Exception e) {
            throw HttpClientException.newInstance(e);
        }
    }

    public HttpStreamRespVO doGetStream(String url) {
        HttpGet httpGet = new HttpGet(url);
        httpGet.setHeaders(this.buildHeaders(null, STREAM_HEADER));
        try {
            HttpStreamRespVO resp = (HttpStreamRespVO)this.httpClient.execute((HttpUriRequest)httpGet, (ResponseHandler)new StreamResponseHandler());
            return resp;
        }
        catch (Exception e) {
            throw HttpClientException.newInstance(e);
        }
    }

    public HttpByteArrayRespVO doGetByteArray(String url) {
        HttpGet httpGet = new HttpGet(url);
        httpGet.setHeaders(this.buildHeaders(null, STREAM_HEADER));
        try {
            HttpByteArrayRespVO resp = (HttpByteArrayRespVO)this.httpClient.execute((HttpUriRequest)httpGet, (ResponseHandler)new ByteArrayResponseHandler());
            return resp;
        }
        catch (Exception e) {
            throw HttpClientException.newInstance(e);
        }
    }

    public HttpTextRespVO doPostWithForm(String url, Map<String, Object> params) {
        return this.doPostWithForm(url, null, params);
    }

    public HttpTextRespVO doPostWithForm(String url, Map<String, String> headers, Map<String, Object> params) {
        HttpPost httpPost = new HttpPost(url);
        httpPost.setHeaders(this.buildHeaders(headers, FORM_HEADER));
        if (params != null && params.size() > 0) {
            HttpEntity entityReq = this.getUrlEncodedFormEntity(params);
            httpPost.setEntity(entityReq);
        }
        try {
            HttpTextRespVO resp = (HttpTextRespVO)this.httpClient.execute((HttpUriRequest)httpPost, (ResponseHandler)new TextResponseHandler());
            return resp;
        }
        catch (Exception e) {
            throw HttpClientException.newInstance(e);
        }
    }

    public HttpTextRespVO doPost(String url, String body) {
        return this.doPost(url, null, body);
    }

    public HttpTextRespVO doPost(String url, Map<String, String> headers, String body) {
        HttpPost httpPost = new HttpPost(url);
        httpPost.setHeaders(this.buildHeaders(headers, JSON_HEADER));
        if (!StringUtil.isNullOrTrimEmptyString((String)body)) {
            StringEntity entity = new StringEntity(body, ContentType.create((String)"plain/text", (Charset)Consts.UTF_8));
            httpPost.setEntity((HttpEntity)entity);
        }
        try {
            HttpTextRespVO resp = (HttpTextRespVO)this.httpClient.execute((HttpUriRequest)httpPost, (ResponseHandler)new TextResponseHandler());
            return resp;
        }
        catch (Exception e) {
            throw HttpClientException.newInstance(e);
        }
    }

    public void shutdown() {
        this.idleThread.shutdown();
    }

    private class IdleConnectionMonitorThread
    extends Thread {
        private final HttpClientConnectionManager connMgr;
        private volatile boolean shutdown = false;

        public IdleConnectionMonitorThread(HttpClientConnectionManager connMgr) {
            this.connMgr = connMgr;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.shutdown) {
                IdleConnectionMonitorThread idleConnectionMonitorThread = this;
                synchronized (idleConnectionMonitorThread) {
                    try {
                        this.wait(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.connMgr.closeExpiredConnections();
                    this.connMgr.closeIdleConnections(30L, TimeUnit.SECONDS);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            this.shutdown = true;
            IdleConnectionMonitorThread idleConnectionMonitorThread = this;
            synchronized (idleConnectionMonitorThread) {
                this.notifyAll();
            }
        }
    }

    private class ByteArrayResponseHandler
    implements ResponseHandler<HttpByteArrayRespVO> {
        private ByteArrayResponseHandler() {
        }

        public HttpByteArrayRespVO handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
            if (response == null || response.getStatusLine() == null) {
                return null;
            }
            int statusCode = response.getStatusLine().getStatusCode();
            HttpByteArrayRespVO result = HttpByteArrayRespVO.newInstance(statusCode);
            if (statusCode == 200) {
                result.setHeader(HttpClientKit.this.parserHeader(response));
                HttpEntity httpEntity = response.getEntity();
                if (httpEntity != null) {
                    byte[] data = BlockIOUtil.toByteArray(httpEntity.getContent());
                    String fileName = HttpClientKit.this.parseFileName(result);
                    result.setEntity(ByteArrayMultipartFile.createFrom(data, fileName));
                }
            } else {
                String err = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
                throw HttpCallException.newInstance(err);
            }
            return result;
        }
    }

    private class StreamResponseHandler
    implements ResponseHandler<HttpStreamRespVO> {
        private StreamResponseHandler() {
        }

        public HttpStreamRespVO handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
            if (response == null || response.getStatusLine() == null) {
                return null;
            }
            int statusCode = response.getStatusLine().getStatusCode();
            HttpStreamRespVO result = HttpStreamRespVO.newInstance(statusCode);
            if (statusCode == 200) {
                result.setHeader(HttpClientKit.this.parserHeader(response));
                HttpEntity httpEntity = response.getEntity();
                if (httpEntity != null) {
                    InputStream inputStream = httpEntity.getContent();
                    String fileName = HttpClientKit.this.parseFileName(result);
                    result.setEntity(StreamMultipartFile.createFrom(inputStream, fileName));
                }
            } else {
                String err = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
                throw HttpCallException.newInstance(err);
            }
            return result;
        }
    }

    private class CustomResponseHandler
    implements ResponseHandler<HttpTextRespVO> {
        private Consumer<HttpResponse> consumer;

        public CustomResponseHandler(Consumer<HttpResponse> consumer) {
            this.consumer = consumer;
        }

        public HttpTextRespVO handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
            if (response == null || response.getStatusLine() == null) {
                return null;
            }
            int statusCode = response.getStatusLine().getStatusCode();
            HttpTextRespVO result = HttpTextRespVO.newInstance(statusCode);
            if (statusCode != 200) {
                String err = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
                throw HttpCallException.newInstance(err);
            }
            result.setHeader(HttpClientKit.this.parserHeader(response));
            this.consumer.accept(response);
            result.setEntity("content-length:" + response.getEntity().getContentLength());
            return result;
        }
    }

    private class TextResponseHandler
    implements ResponseHandler<HttpTextRespVO> {
        private TextResponseHandler() {
        }

        public HttpTextRespVO handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
            if (response == null || response.getStatusLine() == null) {
                return null;
            }
            int statusCode = response.getStatusLine().getStatusCode();
            HttpTextRespVO result = HttpTextRespVO.newInstance(statusCode);
            if (statusCode == 200) {
                result.setHeader(HttpClientKit.this.parserHeader(response));
                HttpEntity entityRes = response.getEntity();
                if (entityRes != null) {
                    result.setEntity(EntityUtils.toString((HttpEntity)entityRes, (String)"UTF-8"));
                }
            } else {
                String err = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
                throw AbcServiceException.newInstance("Http Post\u8bf7\u6c42\u5931\u8d25\u3002" + err);
            }
            return result;
        }
    }
}

