/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.http;

import com.ygsoft.abc.service.http.domain.vo.AbcResponseVO;
import com.ygsoft.ecp.core.mapp.client.MappClient;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class AbcHttpClientUtil {
    private static final int DEFAULT_POOL_MAX_TOTAL = 200;
    private static final int DEFAULT_POOL_MAX_PER_ROUTE = 200;
    private static final int DEFAULT_CONNECT_TIMEOUT = 2000;
    private static final int DEFAULT_CONNECT_REQUEST_TIMEOUT = 2000;
    private static final int DEFAULT_SOCKET_TIMEOUT = 30000;
    private PoolingHttpClientConnectionManager gcm = null;
    private CloseableHttpClient httpClient = null;
    private IdleConnectionMonitorThread idleThread = null;
    private final int maxTotal;
    private final int maxPerRoute;
    private final int connectTimeout;
    private final int connectRequestTimeout;
    private final int socketTimeout;
    private static final Map<Integer, AbcHttpClientUtil> CACHE = new ConcurrentHashMap<Integer, AbcHttpClientUtil>(20);

    public static final AbcHttpClientUtil getDefaultInstance() {
        return AbcHttpClientUtil.getInstance(200, 200, 2000, 2000, 30000);
    }

    public static final AbcHttpClientUtil getInstance(int maxTotal, int maxPerRoute, int connectTimeout, int connectRequestTimeout, int socketTimeout) {
        int cacheKey = maxTotal + maxPerRoute + connectTimeout + connectRequestTimeout + socketTimeout;
        if (CACHE.containsKey(cacheKey)) {
            return CACHE.get(cacheKey);
        }
        AbcHttpClientUtil client = new AbcHttpClientUtil(maxTotal, maxPerRoute, connectTimeout, connectRequestTimeout, socketTimeout);
        CACHE.put(cacheKey, client);
        return client;
    }

    private AbcHttpClientUtil() {
        this(200, 200, 2000, 2000, 30000);
    }

    private AbcHttpClientUtil(int maxTotal, int maxPerRoute, int connectTimeout, int connectRequestTimeout, int socketTimeout) {
        this.maxTotal = maxTotal;
        this.maxPerRoute = maxPerRoute;
        this.connectTimeout = connectTimeout;
        this.connectRequestTimeout = connectRequestTimeout;
        this.socketTimeout = socketTimeout;
        Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)SSLConnectionSocketFactory.getSocketFactory()).build();
        this.gcm = new PoolingHttpClientConnectionManager(registry);
        this.gcm.setMaxTotal(this.maxTotal);
        this.gcm.setDefaultMaxPerRoute(this.maxPerRoute);
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(this.connectTimeout).setSocketTimeout(this.socketTimeout).setConnectionRequestTimeout(this.connectRequestTimeout).build();
        HttpClientBuilder httpClientBuilder = HttpClients.custom();
        this.httpClient = httpClientBuilder.setConnectionManager((HttpClientConnectionManager)this.gcm).setDefaultRequestConfig(requestConfig).build();
        this.idleThread = new IdleConnectionMonitorThread((HttpClientConnectionManager)this.gcm);
        this.idleThread.start();
    }

    private String getMappUrl(String url) {
        String mappUrl = MappClient.getMappUrl((String)url);
        return mappUrl;
    }

    private HttpEntity getUrlEncodedFormEntity(Map<String, Object> params) {
        ArrayList<BasicNameValuePair> pairList = new ArrayList<BasicNameValuePair>(params.size());
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            BasicNameValuePair basicNameValuePair = new BasicNameValuePair(entry.getKey(), entry.getValue().toString());
            pairList.add(basicNameValuePair);
        }
        return new UrlEncodedFormEntity(pairList, Charset.forName("UTF-8"));
    }

    private String getUrlWithParams(String url, Map<String, Object> params) {
        boolean first = true;
        StringBuilder sb = new StringBuilder(url);
        if (params != null) {
            for (String key : params.keySet()) {
                char ch = '&';
                if (first) {
                    ch = '?';
                    first = false;
                }
                String value = params.get(key).toString();
                try {
                    String sval = URLEncoder.encode(value, "UTF-8");
                    sb.append(ch).append(key).append("=").append(sval);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            }
        }
        return sb.toString();
    }

    private AbcResponseVO parseResponse(CloseableHttpResponse response) throws ParseException, IOException {
        if (response == null || response.getStatusLine() == null) {
            return null;
        }
        AbcResponseVO responseVO = new AbcResponseVO();
        int statusCode = response.getStatusLine().getStatusCode();
        responseVO.setStatusCode(statusCode);
        responseVO.setHeader(null);
        responseVO.setEntity(null);
        if (statusCode == 200) {
            HttpEntity entityRes;
            Header[] responseHeaders = response.getAllHeaders();
            if (responseHeaders != null) {
                HashMap<String, List<String>> map = new HashMap<String, List<String>>();
                for (Header h : responseHeaders) {
                    String key = h.getName();
                    if (map.containsKey(key)) {
                        ((List)map.get(key)).add(h.getValue());
                        continue;
                    }
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(h.getValue());
                    map.put(key, list);
                }
                responseVO.setHeader(map);
            }
            if ((entityRes = response.getEntity()) != null) {
                responseVO.setEntity(EntityUtils.toString((HttpEntity)entityRes, (String)"UTF-8"));
            }
        } else {
            String err = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            String errEntity = "";
            if (err.indexOf("<span>HTML 500</span>") != -1) {
                errEntity = "500";
            }
            if (err.indexOf("<span>HTML 404</span>") != -1) {
                errEntity = "404";
            }
            responseVO.setEntity(errEntity);
        }
        return responseVO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbcResponseVO doGet(String url, Map<String, String> headers, Map<String, Object> params) {
        String apiUrl = this.getUrlWithParams(url, params);
        apiUrl = this.getMappUrl(apiUrl);
        HttpGet httpGet = new HttpGet(apiUrl);
        if (headers != null && headers.size() > 0) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                httpGet.addHeader(entry.getKey(), entry.getValue());
            }
        }
        CloseableHttpResponse response = null;
        try {
            AbcResponseVO responseVO;
            response = this.httpClient.execute((HttpUriRequest)httpGet);
            AbcResponseVO abcResponseVO = responseVO = this.parseResponse(response);
            return abcResponseVO;
        }
        catch (IOException iOException) {
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbcResponseVO doPost(String apiUrl, Map<String, String> headers, Map<String, Object> params) {
        String url = this.getMappUrl(apiUrl);
        HttpPost httpPost = new HttpPost(url);
        if (headers != null && headers.size() > 0) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                httpPost.addHeader(entry.getKey(), entry.getValue());
            }
        }
        if (params != null && params.size() > 0) {
            HttpEntity entityReq = this.getUrlEncodedFormEntity(params);
            httpPost.setEntity(entityReq);
        }
        CloseableHttpResponse response = null;
        try {
            AbcResponseVO responseVO;
            response = this.httpClient.execute((HttpUriRequest)httpPost);
            AbcResponseVO abcResponseVO = responseVO = this.parseResponse(response);
            return abcResponseVO;
        }
        catch (IOException iOException) {
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbcResponseVO doPut(String apiUrl, Map<String, String> headers, Map<String, Object> params) {
        String url = this.getMappUrl(apiUrl);
        HttpPut httpPut = new HttpPut(url);
        if (headers != null && headers.size() > 0) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                httpPut.addHeader(entry.getKey(), entry.getValue());
            }
        }
        if (params != null && params.size() > 0) {
            HttpEntity entityReq = this.getUrlEncodedFormEntity(params);
            httpPut.setEntity(entityReq);
        }
        CloseableHttpResponse response = null;
        try {
            AbcResponseVO responseVO;
            response = this.httpClient.execute((HttpUriRequest)httpPut);
            AbcResponseVO abcResponseVO = responseVO = this.parseResponse(response);
            return abcResponseVO;
        }
        catch (IOException iOException) {
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbcResponseVO doDelete(String url, Map<String, String> headers, Map<String, Object> params) {
        String apiUrl = this.getUrlWithParams(url, params);
        apiUrl = this.getMappUrl(apiUrl);
        HttpDelete httpDelete = new HttpDelete(apiUrl);
        if (headers != null && headers.size() > 0) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                httpDelete.addHeader(entry.getKey(), entry.getValue());
            }
        }
        CloseableHttpResponse response = null;
        try {
            AbcResponseVO responseVO;
            response = this.httpClient.execute((HttpUriRequest)httpDelete);
            AbcResponseVO abcResponseVO = responseVO = this.parseResponse(response);
            return abcResponseVO;
        }
        catch (IOException iOException) {
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public void shutdown() {
        this.idleThread.shutdown();
    }

    private class IdleConnectionMonitorThread
    extends Thread {
        private final HttpClientConnectionManager connMgr;
        private volatile boolean exitFlag = false;

        public IdleConnectionMonitorThread(HttpClientConnectionManager connMgr) {
            this.connMgr = connMgr;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.exitFlag) {
                IdleConnectionMonitorThread idleConnectionMonitorThread = this;
                synchronized (idleConnectionMonitorThread) {
                    try {
                        this.wait(2000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                this.connMgr.closeExpiredConnections();
                this.connMgr.closeIdleConnections(30L, TimeUnit.SECONDS);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            this.exitFlag = true;
            IdleConnectionMonitorThread idleConnectionMonitorThread = this;
            synchronized (idleConnectionMonitorThread) {
                this.notify();
            }
        }
    }
}

