/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.document.util;

import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;
import org.xhtmlrenderer.pdf.ITextFontResolver;
import org.xhtmlrenderer.pdf.ITextRenderer;

public final class ITextRenderUtil {
    private static final IEcpLog LOG = EcpLogFactory.getLog(ITextRenderUtil.class);
    public static final String FONT_BASE_DIR = System.getProperty("pdf.font.dir", "");
    public static final String FONT_DEFUALT_DIR_WINDOWS = "C:/Windows/Fonts";
    public static final String FONT_DEFUALT_DIR_LINUX = "/usr/share/fonts";

    private ITextRenderUtil() {
    }

    public static ITextRenderer getITextRenderer() {
        ITextRenderer render = new ITextRenderer();
        ITextFontResolver font = render.getFontResolver();
        String fontDir = FONT_BASE_DIR;
        if (StringUtils.isBlank((CharSequence)fontDir)) {
            if (ITextRenderUtil.isLinux()) {
                fontDir = FONT_DEFUALT_DIR_LINUX;
            }
            if (ITextRenderUtil.isWindows()) {
                fontDir = FONT_DEFUALT_DIR_WINDOWS;
            }
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)String.format("\u5b57\u4f53\u6587\u4ef6\u5939\u8def\u5f84 = %s", fontDir));
        }
        List<String> fileNames = ITextRenderUtil.getFileNamesAllowNull(fontDir);
        for (String fileName : fileNames) {
            if (!fileName.endsWith(".ttc") && !fileName.endsWith(".TTC") && !fileName.endsWith(".ttf") && !fileName.endsWith(".TTF")) continue;
            String fontPath = fontDir + "/" + fileName;
            try {
                font.addFont(fontPath, "Identity-H", false);
                if (!LOG.isInfoEnabled()) continue;
                LOG.info((Object)String.format("\u6dfb\u52a0\u5b57\u4f53\uff0c\u5b57\u4f53\u6587\u4ef6 = %s", fontPath));
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) continue;
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return render;
    }

    private static boolean isLinux() {
        return System.getProperty("os.name").toLowerCase().contains("linux");
    }

    private static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().contains("windows");
    }

    private static List<String> getFileNamesAllowNull(String baseDir) {
        ArrayList<String> fileNames;
        block6: {
            fileNames = new ArrayList<String>();
            try {
                File[] files;
                if (StringUtils.isBlank((CharSequence)baseDir)) {
                    ITextRenderUtil.writeWarnLog("\u5165\u53c2baseDir\u4e3a\u7a7a\uff0c\u5c06\u8fd4\u56de\u957f\u5ea6\u4e3a0\u7684List<String>\u96c6\u5408\u3002");
                    return fileNames;
                }
                File fileDir = new File(baseDir);
                if (!fileDir.exists()) {
                    ITextRenderUtil.writeWarnLog(String.format("\u6587\u4ef6\u5939\u8def\u5f84\u4e0d\u5b58\u5728\uff0c\u5c06\u8fd4\u56de\u957f\u5ea6\u4e3a0\u7684List<String>\u96c6\u5408\u3002\u5165\u53c2baseDir = %s", baseDir));
                    return fileNames;
                }
                for (File file : files = fileDir.listFiles()) {
                    if (!file.isFile()) continue;
                    fileNames.add(file.getName());
                }
                if (CollectionUtils.isEmpty(fileNames)) {
                    ITextRenderUtil.writeWarnLog(String.format("\u6587\u4ef6\u5939\u4e0b\u6ca1\u6709\u5b57\u4f53\u6587\u4ef6\uff0c\u5c06\u8fd4\u56de\u957f\u5ea6\u4e3a0\u7684List<String>\u96c6\u5408\u3002\u5165\u53c2baseDir = %s", baseDir));
                }
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block6;
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return fileNames;
    }

    private static void writeWarnLog(String msg) {
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)msg);
        }
    }
}

