/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.common.domain.vo;

import com.ygsoft.ecp.service.model.IValueObject;
import java.util.Date;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadPoolSettingVO
implements IValueObject {
    private static final long serialVersionUID = 8119347505823584554L;
    private int corePoolSize;
    private int maximumPoolSize;
    private int keepAliveTime;
    private BlockingQueue<Runnable> workQueue;
    private int queueCapacity;
    private int queueElementCount;
    private int queueRemainingCapacity;
    private ThreadFactory threadFactory;
    private RejectedExecutionHandler handler;
    private Date occurTime;

    public static ThreadPoolSettingVO readFrom(ThreadPoolExecutor executor) {
        ThreadPoolSettingVO setting = new ThreadPoolSettingVO();
        setting.setCorePoolSize(executor.getCorePoolSize());
        setting.setMaximumPoolSize(executor.getMaximumPoolSize());
        setting.setKeepAliveTime((int)executor.getKeepAliveTime(TimeUnit.SECONDS));
        setting.setWorkQueue(executor.getQueue());
        setting.setThreadFactory(executor.getThreadFactory());
        setting.setHandler(executor.getRejectedExecutionHandler());
        setting.queueRemainingCapacity = setting.getWorkQueue().remainingCapacity();
        setting.queueElementCount = setting.getWorkQueue().size();
        setting.queueCapacity = setting.queueElementCount + setting.queueRemainingCapacity;
        setting.occurTime = new Date();
        return setting;
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public void setCorePoolSize(int newCorePoolSize) {
        this.corePoolSize = newCorePoolSize;
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public void setMaximumPoolSize(int newMaximumPoolSize) {
        this.maximumPoolSize = newMaximumPoolSize;
    }

    public int getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public void setKeepAliveTime(int newKeepAliveTime) {
        this.keepAliveTime = newKeepAliveTime;
    }

    public BlockingQueue<Runnable> getWorkQueue() {
        return this.workQueue;
    }

    public void setWorkQueue(BlockingQueue<Runnable> newWorkQueue) {
        this.workQueue = newWorkQueue;
    }

    public ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public void setThreadFactory(ThreadFactory newThreadFactory) {
        this.threadFactory = newThreadFactory;
    }

    public RejectedExecutionHandler getHandler() {
        return this.handler;
    }

    public void setHandler(RejectedExecutionHandler newHandler) {
        this.handler = newHandler;
    }

    public int getQueueCapacity() {
        return this.queueCapacity;
    }

    public int getQueueElementCount() {
        return this.queueElementCount;
    }

    public int getQueueRemainingCapacity() {
        return this.queueRemainingCapacity;
    }

    public Date getOccurTime() {
        return this.occurTime;
    }

    public String toString() {
        return "ThreadPoolSettingVO [corePoolSize=" + this.corePoolSize + ", maximumPoolSize=" + this.maximumPoolSize + ", keepAliveTime=" + this.keepAliveTime + ", queueCapacity=" + this.queueCapacity + ", queueElementCount=" + this.queueElementCount + ", queueRemainingCapacity=" + this.queueRemainingCapacity + "]";
    }
}

