/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.ext.pdf.impl;

import com.itextpdf.text.pdf.AcroFields;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfString;
import com.itextpdf.text.pdf.RandomAccessFileOrArray;
import com.itextpdf.text.pdf.security.DigestAlgorithms;
import com.itextpdf.text.pdf.security.EncryptionAlgorithms;
import com.itextpdf.text.pdf.security.PdfPKCS7;
import com.ygsoft.abc.mapp.ygca.ext.pdf.IPdfAlgorithm;
import com.ygsoft.abc.mapp.ygca.ext.pdf.PdfAlgorithmParseException;
import com.ygsoft.abc.mapp.ygca.ext.pdf.PdfAlgorithmValidException;
import com.ygsoft.abc.mapp.ygca.ext.pdf.impl.PdfValidateBase;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.util.HashMap;
import org.bouncycastle162.asn1.ASN1InputStream;
import org.bouncycastle162.asn1.ASN1ObjectIdentifier;
import org.bouncycastle162.asn1.ASN1Primitive;
import org.bouncycastle162.asn1.ASN1Sequence;
import org.bouncycastle162.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfGbAlgorithm
extends PdfValidateBase
implements IPdfAlgorithm {
    private static final Logger LOG = LoggerFactory.getLogger(PdfGbAlgorithm.class);
    private PdfPKCS7 pkcs7;

    public PdfGbAlgorithm(RandomAccessFileOrArray originalPDF, AcroFields acroFields, String signatureName) {
        super(originalPDF, acroFields, signatureName);
    }

    @Override
    public String getValidateName() {
        return "\u56fd\u6807pdf\u9a8c\u7b7e\u7b97\u6cd5";
    }

    @Override
    public Certificate parse() throws PdfAlgorithmParseException {
        Certificate certificate = null;
        ASN1InputStream din = null;
        try {
            PdfDictionary pdfDictionary = this.getAcroFields().getSignatureDictionary(this.getSignatureName());
            PdfName subFilter = pdfDictionary.getAsName(PdfName.SUBFILTER);
            PdfString contents = pdfDictionary.getAsString(PdfName.CONTENTS);
            PdfArray byteRange = pdfDictionary.getAsArray(PdfName.BYTERANGE);
            byte[] signBytes = contents.getOriginalBytes();
            din = new ASN1InputStream((InputStream)new ByteArrayInputStream(signBytes));
            ASN1Primitive pkcs = din.readObject();
            ASN1Sequence signedData = (ASN1Sequence)pkcs;
            ASN1ObjectIdentifier signedDataObjId = (ASN1ObjectIdentifier)signedData.getObjectAt(0);
            if (!"1.2.840.113549.1.7.2".equals(signedDataObjId.getId())) {
                throw new PdfAlgorithmParseException("pdf\u7b7e\u540d\u6570\u636e\u7c7b\u578b\u4e0d\u5339\u914d");
            }
            Security.addProvider((Provider)new BouncyCastleProvider());
            Field digestNamesField = DigestAlgorithms.class.getDeclaredField("digestNames");
            digestNamesField.setAccessible(true);
            HashMap digestNames = (HashMap)digestNamesField.get(null);
            digestNames.put("1.2.156.10197.1.401", "SM3");
            Field algorithmNamesField = EncryptionAlgorithms.class.getDeclaredField("algorithmNames");
            algorithmNamesField.setAccessible(true);
            HashMap algorithmNames = (HashMap)algorithmNamesField.get(null);
            algorithmNames.put("1.2.156.10197.1.501", "SM2");
            this.pkcs7 = this.getAcroFields().verifySignature(this.getSignatureName(), "BC162");
            Certificate[] certificates = this.pkcs7.getCertificates();
            if (certificates == null || certificates.length <= 0) {
                throw new PdfAlgorithmParseException("\u8bc1\u4e66\u5217\u8868\u4e3a\u7a7a");
            }
            certificate = certificates[0];
        }
        catch (Exception e) {
            try {
                if (e instanceof PdfAlgorithmParseException) {
                    throw (PdfAlgorithmParseException)e;
                }
                throw new PdfAlgorithmParseException("\u7b7e\u540d\u4fe1\u606f\u89e3\u6790\u5931\u8d25", e);
            }
            catch (Throwable throwable) {
                PdfGbAlgorithm.close(new Closeable[]{din});
                throw throwable;
            }
        }
        PdfGbAlgorithm.close(new Closeable[]{din});
        return certificate;
    }

    @Override
    public Boolean validate() throws PdfAlgorithmValidException, PdfAlgorithmParseException {
        boolean result;
        try {
            result = this.pkcs7.verify();
        }
        catch (GeneralSecurityException e) {
            throw new PdfAlgorithmParseException("\u7b7e\u540d\u503c\u7b97\u6cd5\u5339\u914d\u5931\u8d25", e);
        }
        return result;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

