/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.tsp;

import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle162.asn1.tsp.PartialHashtree;
import org.bouncycastle162.operator.DigestCalculator;
import org.bouncycastle162.tsp.PartialHashTreeVerificationException;
import org.bouncycastle162.util.Arrays;

public class PartialHashTreeProcessor {
    private final byte[][] values;

    public PartialHashTreeProcessor(PartialHashtree tree) {
        this.values = tree.getValues();
    }

    public byte[] getHash(DigestCalculator digestCalculator) {
        if (this.values.length == 1) {
            return this.values[0];
        }
        try {
            OutputStream dOut = digestCalculator.getOutputStream();
            for (int i = 1; i != this.values.length; ++i) {
                dOut.write(this.values[i]);
            }
            return digestCalculator.getDigest();
        }
        catch (IOException e) {
            throw new IllegalStateException("calculator failed: " + e.getMessage());
        }
    }

    public void verifyContainsHash(byte[] hash) throws PartialHashTreeVerificationException {
        if (!this.containsHash(hash)) {
            throw new PartialHashTreeVerificationException("calculated hash is not present in partial hash tree");
        }
    }

    public boolean containsHash(byte[] hash) {
        for (int i = 1; i != this.values.length; ++i) {
            if (!Arrays.areEqual(hash, this.values[i])) continue;
            return true;
        }
        return false;
    }
}

