/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.crypto.test;

import org.bouncycastle162.crypto.digests.NonMemoableDigest;
import org.bouncycastle162.crypto.digests.SHA1Digest;
import org.bouncycastle162.crypto.macs.HMac;
import org.bouncycastle162.crypto.params.KeyParameter;
import org.bouncycastle162.util.Arrays;
import org.bouncycastle162.util.Strings;
import org.bouncycastle162.util.encoders.Hex;
import org.bouncycastle162.util.test.SimpleTestResult;
import org.bouncycastle162.util.test.Test;
import org.bouncycastle162.util.test.TestResult;

public class NonMemoableDigestTest
implements Test {
    static final String[] keys = new String[]{"0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b", "4a656665", "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa", "0102030405060708090a0b0c0d0e0f10111213141516171819", "0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c", "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa", "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"};
    static final String[] digests = new String[]{"b617318655057264e28bc0b6fb378c8ef146be00", "effcdf6ae5eb2fa2d27416d5f184df9c259a7c79", "125d7342b9ac11cd91a39af48aa17b4f63f175d3", "4c9007f4026250c6bc8414f9bf50c86c2d7235da", "4c1a03424b55e07fe7f27be1d58bb9324a9a5a04", "aa4ae5e15272d00e95705637ce8a3b55ed402112", "e8e99d0f45237d786d6bbaa7965c7808bbff1a91", "4c1a03424b55e07fe7f27be1d58bb9324a9a5a04", "aa4ae5e15272d00e95705637ce8a3b55ed402112", "e8e99d0f45237d786d6bbaa7965c7808bbff1a91"};
    static final String[] messages = new String[]{"Hi There", "what do ya want for nothing?", "0xdddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd", "0xcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcd", "Test With Truncation", "Test Using Larger Than Block-Size Key - Hash Key First", "Test Using Larger Than Block-Size Key and Larger Than One Block-Size Data"};

    public String getName() {
        return "NonMemoableDigest";
    }

    public TestResult perform() {
        byte[] m;
        HMac hmac = new HMac(new NonMemoableDigest(new SHA1Digest()));
        byte[] resBuf = new byte[hmac.getMacSize()];
        for (int i = 0; i < messages.length; ++i) {
            m = Strings.toByteArray(messages[i]);
            if (messages[i].startsWith("0x")) {
                m = Hex.decode(messages[i].substring(2));
            }
            hmac.init(new KeyParameter(Hex.decode(keys[i])));
            hmac.update(m, 0, m.length);
            hmac.doFinal(resBuf, 0);
            if (Arrays.areEqual(resBuf, Hex.decode(digests[i]))) continue;
            return new SimpleTestResult(false, this.getName() + ": Vector " + i + " failed");
        }
        int vector = 0;
        m = Strings.toByteArray(messages[vector]);
        if (messages[vector].startsWith("0x")) {
            m = Hex.decode(messages[vector].substring(2));
        }
        hmac.init(new KeyParameter(Hex.decode(keys[vector])));
        hmac.update(m, 0, m.length);
        hmac.doFinal(resBuf, 0);
        hmac.reset();
        hmac.update(m, 0, m.length);
        hmac.doFinal(resBuf, 0);
        if (!Arrays.areEqual(resBuf, Hex.decode(digests[vector]))) {
            return new SimpleTestResult(false, this.getName() + ": Reset with vector " + vector + " failed");
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public static void main(String[] args) {
        NonMemoableDigestTest test = new NonMemoableDigestTest();
        TestResult result = test.perform();
        System.out.println(result);
    }
}

