/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.crypto.generators;

import java.security.SecureRandom;
import org.bouncycastle162.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle162.crypto.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle162.crypto.KeyGenerationParameters;
import org.bouncycastle162.crypto.params.Ed448PrivateKeyParameters;
import org.bouncycastle162.crypto.params.Ed448PublicKeyParameters;

public class Ed448KeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private SecureRandom random;

    public void init(KeyGenerationParameters parameters) {
        this.random = parameters.getRandom();
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        Ed448PrivateKeyParameters privateKey = new Ed448PrivateKeyParameters(this.random);
        Ed448PublicKeyParameters publicKey = privateKey.generatePublicKey();
        return new AsymmetricCipherKeyPair(publicKey, privateKey);
    }
}

