/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.crypto.digests;

import org.bouncycastle162.crypto.ExtendedDigest;
import org.bouncycastle162.crypto.digests.SkeinEngine;
import org.bouncycastle162.crypto.params.SkeinParameters;
import org.bouncycastle162.util.Memoable;

public class SkeinDigest
implements ExtendedDigest,
Memoable {
    public static final int SKEIN_256 = 256;
    public static final int SKEIN_512 = 512;
    public static final int SKEIN_1024 = 1024;
    private SkeinEngine engine;

    public SkeinDigest(int stateSizeBits, int digestSizeBits) {
        this.engine = new SkeinEngine(stateSizeBits, digestSizeBits);
        this.init(null);
    }

    public SkeinDigest(SkeinDigest digest) {
        this.engine = new SkeinEngine(digest.engine);
    }

    public void reset(Memoable other) {
        SkeinDigest d = (SkeinDigest)other;
        this.engine.reset(d.engine);
    }

    public Memoable copy() {
        return new SkeinDigest(this);
    }

    public String getAlgorithmName() {
        return "Skein-" + this.engine.getBlockSize() * 8 + "-" + this.engine.getOutputSize() * 8;
    }

    public int getDigestSize() {
        return this.engine.getOutputSize();
    }

    public int getByteLength() {
        return this.engine.getBlockSize();
    }

    public void init(SkeinParameters params) {
        this.engine.init(params);
    }

    public void reset() {
        this.engine.reset();
    }

    public void update(byte in) {
        this.engine.update(in);
    }

    public void update(byte[] in, int inOff, int len) {
        this.engine.update(in, inOff, len);
    }

    public int doFinal(byte[] out, int outOff) {
        return this.engine.doFinal(out, outOff);
    }
}

