/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.cms.bc;

import java.security.SecureRandom;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle162.asn1.ASN1ObjectIdentifier;
import org.bouncycastle162.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle162.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle162.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle162.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle162.cms.CMSAlgorithm;
import org.bouncycastle162.cms.CMSException;
import org.bouncycastle162.crypto.CipherKeyGenerator;
import org.bouncycastle162.crypto.CipherParameters;
import org.bouncycastle162.crypto.ExtendedDigest;
import org.bouncycastle162.crypto.Wrapper;
import org.bouncycastle162.crypto.digests.SHA1Digest;
import org.bouncycastle162.crypto.digests.SHA224Digest;
import org.bouncycastle162.crypto.digests.SHA256Digest;
import org.bouncycastle162.crypto.digests.SHA384Digest;
import org.bouncycastle162.crypto.digests.SHA512Digest;
import org.bouncycastle162.crypto.engines.AESEngine;
import org.bouncycastle162.crypto.engines.DESEngine;
import org.bouncycastle162.crypto.engines.DESedeEngine;
import org.bouncycastle162.crypto.engines.RC2Engine;
import org.bouncycastle162.crypto.engines.RFC3211WrapEngine;
import org.bouncycastle162.crypto.params.KeyParameter;
import org.bouncycastle162.crypto.util.AlgorithmIdentifierFactory;
import org.bouncycastle162.crypto.util.CipherFactory;
import org.bouncycastle162.crypto.util.CipherKeyGeneratorFactory;
import org.bouncycastle162.operator.OperatorCreationException;
import org.bouncycastle162.operator.bc.BcDigestProvider;

class EnvelopedDataHelper {
    protected static final Map BASE_CIPHER_NAMES = new HashMap();
    protected static final Map MAC_ALG_NAMES = new HashMap();
    private static final Map prfs = EnvelopedDataHelper.createTable();

    private static Map createTable() {
        HashMap<ASN1ObjectIdentifier, BcDigestProvider> table = new HashMap<ASN1ObjectIdentifier, BcDigestProvider>();
        table.put(PKCSObjectIdentifiers.id_hmacWithSHA1, new BcDigestProvider(){

            public ExtendedDigest get(AlgorithmIdentifier digestAlgorithmIdentifier) {
                return new SHA1Digest();
            }
        });
        table.put(PKCSObjectIdentifiers.id_hmacWithSHA224, new BcDigestProvider(){

            public ExtendedDigest get(AlgorithmIdentifier digestAlgorithmIdentifier) {
                return new SHA224Digest();
            }
        });
        table.put(PKCSObjectIdentifiers.id_hmacWithSHA256, new BcDigestProvider(){

            public ExtendedDigest get(AlgorithmIdentifier digestAlgorithmIdentifier) {
                return new SHA256Digest();
            }
        });
        table.put(PKCSObjectIdentifiers.id_hmacWithSHA384, new BcDigestProvider(){

            public ExtendedDigest get(AlgorithmIdentifier digestAlgorithmIdentifier) {
                return new SHA384Digest();
            }
        });
        table.put(PKCSObjectIdentifiers.id_hmacWithSHA512, new BcDigestProvider(){

            public ExtendedDigest get(AlgorithmIdentifier digestAlgorithmIdentifier) {
                return new SHA512Digest();
            }
        });
        return Collections.unmodifiableMap(table);
    }

    EnvelopedDataHelper() {
    }

    static ExtendedDigest getPRF(AlgorithmIdentifier algID) throws OperatorCreationException {
        return ((BcDigestProvider)prfs.get(algID.getAlgorithm())).get(null);
    }

    static Wrapper createRFC3211Wrapper(ASN1ObjectIdentifier algorithm) throws CMSException {
        if (NISTObjectIdentifiers.id_aes128_CBC.equals(algorithm) || NISTObjectIdentifiers.id_aes192_CBC.equals(algorithm) || NISTObjectIdentifiers.id_aes256_CBC.equals(algorithm)) {
            return new RFC3211WrapEngine(new AESEngine());
        }
        if (PKCSObjectIdentifiers.des_EDE3_CBC.equals(algorithm)) {
            return new RFC3211WrapEngine(new DESedeEngine());
        }
        if (OIWObjectIdentifiers.desCBC.equals(algorithm)) {
            return new RFC3211WrapEngine(new DESEngine());
        }
        if (PKCSObjectIdentifiers.RC2_CBC.equals(algorithm)) {
            return new RFC3211WrapEngine(new RC2Engine());
        }
        throw new CMSException("cannot recognise wrapper: " + algorithm);
    }

    static Object createContentCipher(boolean forEncryption, CipherParameters encKey, AlgorithmIdentifier encryptionAlgID) throws CMSException {
        try {
            return CipherFactory.createContentCipher(forEncryption, encKey, encryptionAlgID);
        }
        catch (IllegalArgumentException e) {
            throw new CMSException(e.getMessage(), e);
        }
    }

    AlgorithmIdentifier generateEncryptionAlgID(ASN1ObjectIdentifier encryptionOID, KeyParameter encKey, SecureRandom random) throws CMSException {
        try {
            return AlgorithmIdentifierFactory.generateEncryptionAlgID(encryptionOID, encKey.getKey().length * 8, random);
        }
        catch (IllegalArgumentException e) {
            throw new CMSException(e.getMessage(), e);
        }
    }

    CipherKeyGenerator createKeyGenerator(ASN1ObjectIdentifier algorithm, SecureRandom random) throws CMSException {
        try {
            return CipherKeyGeneratorFactory.createKeyGenerator(algorithm, random);
        }
        catch (IllegalArgumentException e) {
            throw new CMSException(e.getMessage(), e);
        }
    }

    static {
        BASE_CIPHER_NAMES.put(CMSAlgorithm.DES_EDE3_CBC, "DESEDE");
        BASE_CIPHER_NAMES.put(CMSAlgorithm.AES128_CBC, "AES");
        BASE_CIPHER_NAMES.put(CMSAlgorithm.AES192_CBC, "AES");
        BASE_CIPHER_NAMES.put(CMSAlgorithm.AES256_CBC, "AES");
        MAC_ALG_NAMES.put(CMSAlgorithm.DES_EDE3_CBC, "DESEDEMac");
        MAC_ALG_NAMES.put(CMSAlgorithm.AES128_CBC, "AESMac");
        MAC_ALG_NAMES.put(CMSAlgorithm.AES192_CBC, "AESMac");
        MAC_ALG_NAMES.put(CMSAlgorithm.AES256_CBC, "AESMac");
        MAC_ALG_NAMES.put(CMSAlgorithm.RC2_CBC, "RC2Mac");
    }
}

