/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.cms;

import org.bouncycastle162.asn1.ASN1OctetString;
import org.bouncycastle162.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle162.asn1.cms.KeyTransRecipientInfo;
import org.bouncycastle162.asn1.cms.RecipientIdentifier;
import org.bouncycastle162.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle162.cms.AuthAttributesProvider;
import org.bouncycastle162.cms.CMSException;
import org.bouncycastle162.cms.CMSSecureReadable;
import org.bouncycastle162.cms.KeyTransRecipient;
import org.bouncycastle162.cms.KeyTransRecipientId;
import org.bouncycastle162.cms.Recipient;
import org.bouncycastle162.cms.RecipientInformation;
import org.bouncycastle162.cms.RecipientOperator;

public class KeyTransRecipientInformation
extends RecipientInformation {
    private KeyTransRecipientInfo info;

    KeyTransRecipientInformation(KeyTransRecipientInfo info, AlgorithmIdentifier messageAlgorithm, CMSSecureReadable secureReadable, AuthAttributesProvider additionalData) {
        super(info.getKeyEncryptionAlgorithm(), messageAlgorithm, secureReadable, additionalData);
        this.info = info;
        RecipientIdentifier r = info.getRecipientIdentifier();
        if (r.isTagged()) {
            ASN1OctetString octs = ASN1OctetString.getInstance(r.getId());
            this.rid = new KeyTransRecipientId(octs.getOctets());
        } else {
            IssuerAndSerialNumber iAnds = IssuerAndSerialNumber.getInstance(r.getId());
            this.rid = new KeyTransRecipientId(iAnds.getName(), iAnds.getSerialNumber().getValue());
        }
    }

    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException {
        return ((KeyTransRecipient)recipient).getRecipientOperator(this.keyEncAlg, this.messageAlgorithm, this.info.getEncryptedKey().getOctets());
    }
}

