/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.cms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import org.bouncycastle162.asn1.BEROctetString;
import org.bouncycastle162.asn1.BERSet;
import org.bouncycastle162.asn1.cms.AttributeTable;
import org.bouncycastle162.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle162.asn1.cms.ContentInfo;
import org.bouncycastle162.asn1.cms.EncryptedContentInfo;
import org.bouncycastle162.asn1.cms.EncryptedData;
import org.bouncycastle162.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle162.cms.CMSEncryptedData;
import org.bouncycastle162.cms.CMSEncryptedGenerator;
import org.bouncycastle162.cms.CMSException;
import org.bouncycastle162.cms.CMSTypedData;
import org.bouncycastle162.operator.OutputEncryptor;

public class CMSEncryptedDataGenerator
extends CMSEncryptedGenerator {
    private CMSEncryptedData doGenerate(CMSTypedData content, OutputEncryptor contentEncryptor) throws CMSException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        try {
            OutputStream cOut = contentEncryptor.getOutputStream(bOut);
            content.write(cOut);
            cOut.close();
        }
        catch (IOException e) {
            throw new CMSException("");
        }
        byte[] encryptedContent = bOut.toByteArray();
        AlgorithmIdentifier encAlgId = contentEncryptor.getAlgorithmIdentifier();
        BEROctetString encContent = new BEROctetString(encryptedContent);
        EncryptedContentInfo eci = new EncryptedContentInfo(content.getContentType(), encAlgId, encContent);
        BERSet unprotectedAttrSet = null;
        if (this.unprotectedAttributeGenerator != null) {
            AttributeTable attrTable = this.unprotectedAttributeGenerator.getAttributes(new HashMap());
            unprotectedAttrSet = new BERSet(attrTable.toASN1EncodableVector());
        }
        ContentInfo contentInfo = new ContentInfo(CMSObjectIdentifiers.encryptedData, new EncryptedData(eci, unprotectedAttrSet));
        return new CMSEncryptedData(contentInfo);
    }

    public CMSEncryptedData generate(CMSTypedData content, OutputEncryptor contentEncryptor) throws CMSException {
        return this.doGenerate(content, contentEncryptor);
    }
}

