/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.eepsp.service.explain.voucher.impl.service;

import com.google.common.collect.Maps;
import com.ygsoft.abc.eepsp.service.explain.voucher.domain.bo.DrAndCrItemBO;
import com.ygsoft.abc.eepsp.service.explain.voucher.domain.model.DrAndCrItem;
import com.ygsoft.abc.eepsp.service.explain.voucher.impl.transfer.DrAndCrItemTransfer;
import com.ygsoft.abc.eepsp.service.explain.voucher.repositories.IDrAndCrItemRepository;
import com.ygsoft.abc.eepsp.service.explain.voucher.service.IDrAndCrItemQueryService;
import com.ygsoft.abc.service.annotation.TLog;
import com.ygsoft.abc.service.tool.BlockCollectionUtil;
import com.ygsoft.necp.component.genentity.spec.GenEntityContext;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class DrAndCrItemQueryService
extends GenEntityContext<DrAndCrItem, String, IDrAndCrItemRepository>
implements IDrAndCrItemQueryService {
    @Override
    @TLog
    public List<DrAndCrItemBO> findByAccountingGid(String accountingGid) {
        List<DrAndCrItem> listPO = ((IDrAndCrItemRepository)this.getDao()).findByAccountingGid(accountingGid);
        return DrAndCrItemTransfer.getInstance().toBOs(listPO);
    }

    @Override
    @TLog
    public Map<String, List<DrAndCrItemBO>> findByAccountingGidIn(List<String> listAccountingGid) {
        List<DrAndCrItem> listPO = ((IDrAndCrItemRepository)this.getDao()).findByAccountingGidIn(listAccountingGid);
        if (BlockCollectionUtil.isEmpty(listPO)) {
            return Maps.newHashMap();
        }
        List<DrAndCrItemBO> listBO = DrAndCrItemTransfer.getInstance().toBOs(listPO);
        Map<String, List<DrAndCrItemBO>> map = listBO.stream().collect(Collectors.groupingBy(DrAndCrItemBO::getAccountingGid));
        return map;
    }
}

