/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.pqc.math.ntru.polynomial.test;

import java.security.SecureRandom;
import junit.framework.TestCase;
import org.bouncycastle162.pqc.crypto.ntru.NTRUEncryptionKeyGenerationParameters;
import org.bouncycastle162.pqc.math.ntru.polynomial.IntegerPolynomial;
import org.bouncycastle162.pqc.math.ntru.polynomial.ProductFormPolynomial;
import org.bouncycastle162.pqc.math.ntru.polynomial.test.PolynomialGenerator;

public class ProductFormPolynomialTest
extends TestCase {
    private NTRUEncryptionKeyGenerationParameters params;
    private int N;
    private int df1;
    private int df2;
    private int df3;
    private int q;

    public void setUp() {
        this.params = NTRUEncryptionKeyGenerationParameters.APR2011_439_FAST;
        this.N = this.params.N;
        this.df1 = this.params.df1;
        this.df2 = this.params.df2;
        this.df3 = this.params.df3;
        this.q = this.params.q;
    }

    public void testFromToBinary() throws Exception {
        ProductFormPolynomial p1 = ProductFormPolynomial.generateRandom(this.N, this.df1, this.df2, this.df3, this.df3 - 1, new SecureRandom());
        byte[] bin1 = p1.toBinary();
        ProductFormPolynomial p2 = ProductFormPolynomial.fromBinary(bin1, this.N, this.df1, this.df2, this.df3, this.df3 - 1);
        ProductFormPolynomialTest.assertEquals((Object)p1, (Object)p2);
    }

    public void testMult() {
        ProductFormPolynomial p1 = ProductFormPolynomial.generateRandom(this.N, this.df1, this.df2, this.df3, this.df3 - 1, new SecureRandom());
        IntegerPolynomial p2 = PolynomialGenerator.generateRandom(this.N, this.q);
        IntegerPolynomial p3 = p1.mult(p2);
        IntegerPolynomial p4 = p1.toIntegerPolynomial().mult(p2);
        ProductFormPolynomialTest.assertEquals((Object)p3, (Object)p4);
    }
}

