/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.jcajce.provider.digest;

import org.bouncycastle162.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle162.crypto.CipherKeyGenerator;
import org.bouncycastle162.crypto.digests.MD4Digest;
import org.bouncycastle162.crypto.macs.HMac;
import org.bouncycastle162.jcajce.provider.config.ConfigurableProvider;
import org.bouncycastle162.jcajce.provider.digest.BCMessageDigest;
import org.bouncycastle162.jcajce.provider.digest.DigestAlgorithmProvider;
import org.bouncycastle162.jcajce.provider.symmetric.util.BaseKeyGenerator;
import org.bouncycastle162.jcajce.provider.symmetric.util.BaseMac;

public class MD4 {
    private MD4() {
    }

    public static class Mappings
    extends DigestAlgorithmProvider {
        private static final String PREFIX = MD4.class.getName();

        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("MessageDigest.MD4", PREFIX + "$Digest");
            provider.addAlgorithm("Alg.Alias.MessageDigest." + PKCSObjectIdentifiers.md4, "MD4");
            this.addHMACAlgorithm(provider, "MD4", PREFIX + "$HashMac", PREFIX + "$KeyGenerator");
        }
    }

    public static class Digest
    extends BCMessageDigest
    implements Cloneable {
        public Digest() {
            super(new MD4Digest());
        }

        public Object clone() throws CloneNotSupportedException {
            Digest d = (Digest)super.clone();
            d.digest = new MD4Digest((MD4Digest)this.digest);
            return d;
        }
    }

    public static class KeyGenerator
    extends BaseKeyGenerator {
        public KeyGenerator() {
            super("HMACMD4", 128, new CipherKeyGenerator());
        }
    }

    public static class HashMac
    extends BaseMac {
        public HashMac() {
            super(new HMac(new MD4Digest()));
        }
    }
}

