/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.crypto.test;

import java.io.IOException;
import java.security.SecureRandom;
import junit.framework.TestCase;
import org.bouncycastle162.crypto.modes.gcm.GCMExponentiator;
import org.bouncycastle162.crypto.modes.gcm.GCMMultiplier;
import org.bouncycastle162.crypto.modes.gcm.Tables1kGCMExponentiator;
import org.bouncycastle162.crypto.modes.gcm.Tables4kGCMMultiplier;
import org.bouncycastle162.util.Arrays;
import org.bouncycastle162.util.Pack;
import org.bouncycastle162.util.encoders.Hex;

public class GCMReorderTest
extends TestCase {
    private static final byte[] H;
    private static final SecureRandom random;
    private static final GCMMultiplier mul;
    private static final GCMExponentiator exp;
    private static final byte[] EMPTY;

    public void testCombine() throws Exception {
        for (int count = 0; count < 10; ++count) {
            byte[] A = this.randomBytes(1000);
            byte[] C = this.randomBytes(1000);
            byte[] ghashA_ = this.GHASH(A, EMPTY);
            byte[] ghash_C = this.GHASH(EMPTY, C);
            byte[] ghashAC = this.GHASH(A, C);
            byte[] ghashCombine = this.combine_GHASH(ghashA_, (long)A.length * 8L, ghash_C, (long)C.length * 8L);
            GCMReorderTest.assertTrue((boolean)Arrays.areEqual(ghashAC, ghashCombine));
        }
    }

    public void testConcatAuth() throws Exception {
        for (int count = 0; count < 10; ++count) {
            byte[] P = this.randomBlocks(100);
            byte[] A = this.randomBytes(1000);
            byte[] PA = this.concatArrays(P, A);
            byte[] ghashP_ = this.GHASH(P, EMPTY);
            byte[] ghashA_ = this.GHASH(A, EMPTY);
            byte[] ghashPA_ = this.GHASH(PA, EMPTY);
            byte[] ghashConcat = this.concatAuth_GHASH(ghashP_, (long)P.length * 8L, ghashA_, (long)A.length * 8L);
            GCMReorderTest.assertTrue((boolean)Arrays.areEqual(ghashPA_, ghashConcat));
        }
    }

    public void testConcatCrypt() throws Exception {
        for (int count = 0; count < 10; ++count) {
            byte[] P = this.randomBlocks(100);
            byte[] A = this.randomBytes(1000);
            byte[] PA = this.concatArrays(P, A);
            byte[] ghash_P = this.GHASH(EMPTY, P);
            byte[] ghash_A = this.GHASH(EMPTY, A);
            byte[] ghash_PA = this.GHASH(EMPTY, PA);
            byte[] ghashConcat = this.concatCrypt_GHASH(ghash_P, (long)P.length * 8L, ghash_A, (long)A.length * 8L);
            GCMReorderTest.assertTrue((boolean)Arrays.areEqual(ghash_PA, ghashConcat));
        }
    }

    public void testExp() {
        byte[] buf1 = new byte[16];
        buf1[0] = -128;
        byte[] buf2 = new byte[16];
        for (int pow = 0; pow != 100; ++pow) {
            exp.exponentiateX(pow, buf2);
            GCMReorderTest.assertTrue((boolean)Arrays.areEqual(buf1, buf2));
            mul.multiplyH(buf1);
        }
        long[] testPow = new long[]{10L, 1L, 8L, 17L, 24L, 13L, 2L, 13L, 2L, 3L};
        byte[][] testData = new byte[][]{Hex.decode("9185848a877bd87ba071e281f476e8e7"), Hex.decode("697ce3052137d80745d524474fb6b290"), Hex.decode("2696fc47198bb23b11296e4f88720a17"), Hex.decode("01f2f0ead011a4ae0cf3572f1b76dd8e"), Hex.decode("a53060694a044e4b7fa1e661c5a7bb6b"), Hex.decode("39c0392e8b6b0e04a7565c85394c2c4c"), Hex.decode("519c362d502e07f2d8b7597a359a5214"), Hex.decode("5a527a393675705e19b2117f67695af4"), Hex.decode("27fc0901d1d332a53ba4d4386c2109d2"), Hex.decode("93ca9b57174aabedf8220e83366d7df6")};
        for (int i = 0; i != 10; ++i) {
            long pow = testPow[i];
            byte[] data = Arrays.clone(testData[i]);
            byte[] expected = Arrays.clone(data);
            int j = 0;
            while ((long)j < pow) {
                mul.multiplyH(expected);
                ++j;
            }
            byte[] H_a = new byte[16];
            exp.exponentiateX(pow, H_a);
            byte[] actual = GCMReorderTest.multiply(data, H_a);
            GCMReorderTest.assertTrue((boolean)Arrays.areEqual(expected, actual));
        }
    }

    public void testMultiply() {
        byte[] expected = Arrays.clone(H);
        mul.multiplyH(expected);
        GCMReorderTest.assertTrue((boolean)Arrays.areEqual(expected, GCMReorderTest.multiply(H, H)));
        for (int count = 0; count < 10; ++count) {
            byte[] a = new byte[16];
            random.nextBytes(a);
            byte[] b = new byte[16];
            random.nextBytes(b);
            expected = Arrays.clone(a);
            mul.multiplyH(expected);
            GCMReorderTest.assertTrue((boolean)Arrays.areEqual(expected, GCMReorderTest.multiply(a, H)));
            GCMReorderTest.assertTrue((boolean)Arrays.areEqual(expected, GCMReorderTest.multiply(H, a)));
            expected = Arrays.clone(b);
            mul.multiplyH(expected);
            GCMReorderTest.assertTrue((boolean)Arrays.areEqual(expected, GCMReorderTest.multiply(b, H)));
            GCMReorderTest.assertTrue((boolean)Arrays.areEqual(expected, GCMReorderTest.multiply(H, b)));
            GCMReorderTest.assertTrue((boolean)Arrays.areEqual(GCMReorderTest.multiply(a, b), GCMReorderTest.multiply(b, a)));
        }
    }

    private byte[] randomBlocks(int upper) {
        byte[] bs = new byte[16 * random.nextInt(upper)];
        random.nextBytes(bs);
        return bs;
    }

    private byte[] randomBytes(int upper) {
        byte[] bs = new byte[random.nextInt(upper)];
        random.nextBytes(bs);
        return bs;
    }

    private byte[] concatArrays(byte[] a, byte[] b) throws IOException {
        byte[] ab = new byte[a.length + b.length];
        System.arraycopy(a, 0, ab, 0, a.length);
        System.arraycopy(b, 0, ab, a.length, b.length);
        return ab;
    }

    private byte[] combine_GHASH(byte[] ghashA_, long bitlenA, byte[] ghash_C, long bitlenC) {
        long c = bitlenC + 127L >>> 7;
        byte[] H_c = new byte[16];
        exp.exponentiateX(c, H_c);
        byte[] tmp1 = GCMReorderTest.lengthBlock(bitlenA, 0L);
        mul.multiplyH(tmp1);
        byte[] ghashAC = Arrays.clone(ghashA_);
        GCMReorderTest.xor(ghashAC, tmp1);
        ghashAC = GCMReorderTest.multiply(ghashAC, H_c);
        GCMReorderTest.xor(ghashAC, tmp1);
        GCMReorderTest.xor(ghashAC, ghash_C);
        return ghashAC;
    }

    private byte[] concatAuth_GHASH(byte[] ghashP, long bitlenP, byte[] ghashA, long bitlenA) {
        long a = bitlenA + 127L >>> 7;
        byte[] tmp1 = GCMReorderTest.lengthBlock(bitlenP, 0L);
        mul.multiplyH(tmp1);
        byte[] tmp2 = GCMReorderTest.lengthBlock(bitlenA ^ bitlenP + bitlenA, 0L);
        mul.multiplyH(tmp2);
        byte[] H_a = new byte[16];
        exp.exponentiateX(a, H_a);
        byte[] ghashC = Arrays.clone(ghashP);
        GCMReorderTest.xor(ghashC, tmp1);
        ghashC = GCMReorderTest.multiply(ghashC, H_a);
        GCMReorderTest.xor(ghashC, tmp2);
        GCMReorderTest.xor(ghashC, ghashA);
        return ghashC;
    }

    private byte[] concatCrypt_GHASH(byte[] ghashP, long bitlenP, byte[] ghashA, long bitlenA) {
        long a = bitlenA + 127L >>> 7;
        byte[] tmp1 = GCMReorderTest.lengthBlock(0L, bitlenP);
        mul.multiplyH(tmp1);
        byte[] tmp2 = GCMReorderTest.lengthBlock(0L, bitlenA ^ bitlenP + bitlenA);
        mul.multiplyH(tmp2);
        byte[] H_a = new byte[16];
        exp.exponentiateX(a, H_a);
        byte[] ghashC = Arrays.clone(ghashP);
        GCMReorderTest.xor(ghashC, tmp1);
        ghashC = GCMReorderTest.multiply(ghashC, H_a);
        GCMReorderTest.xor(ghashC, tmp2);
        GCMReorderTest.xor(ghashC, ghashA);
        return ghashC;
    }

    private byte[] GHASH(byte[] A, byte[] C) {
        int num;
        byte[] tmp;
        int pos;
        byte[] X = new byte[16];
        for (pos = 0; pos < A.length; pos += 16) {
            tmp = new byte[16];
            num = Math.min(A.length - pos, 16);
            System.arraycopy(A, pos, tmp, 0, num);
            GCMReorderTest.xor(X, tmp);
            mul.multiplyH(X);
        }
        for (pos = 0; pos < C.length; pos += 16) {
            tmp = new byte[16];
            num = Math.min(C.length - pos, 16);
            System.arraycopy(C, pos, tmp, 0, num);
            GCMReorderTest.xor(X, tmp);
            mul.multiplyH(X);
        }
        GCMReorderTest.xor(X, GCMReorderTest.lengthBlock((long)A.length * 8L, (long)C.length * 8L));
        mul.multiplyH(X);
        return X;
    }

    private static byte[] lengthBlock(long bitlenA, long bitlenC) {
        byte[] tmp = new byte[16];
        Pack.longToBigEndian(bitlenA, tmp, 0);
        Pack.longToBigEndian(bitlenC, tmp, 8);
        return tmp;
    }

    private static void xor(byte[] block, byte[] val) {
        for (int i = 15; i >= 0; --i) {
            int n = i;
            block[n] = (byte)(block[n] ^ val[i]);
        }
    }

    private static byte[] multiply(byte[] a, byte[] b) {
        byte[] c = new byte[16];
        byte[] tmp = Arrays.clone(b);
        for (int i = 0; i < 16; ++i) {
            byte bits = a[i];
            for (int j = 7; j >= 0; --j) {
                if ((bits & 1 << j) != 0) {
                    GCMReorderTest.xor(c, tmp);
                }
                boolean lsb = (tmp[15] & 1) != 0;
                GCMReorderTest.shiftRight(tmp);
                if (!lsb) continue;
                tmp[0] = (byte)(tmp[0] ^ 0xFFFFFFE1);
            }
        }
        return c;
    }

    private static void shiftRight(byte[] block) {
        int i = 0;
        int bit = 0;
        while (true) {
            int b = block[i] & 0xFF;
            block[i] = (byte)(b >>> 1 | bit);
            if (++i == 16) break;
            bit = (b & 1) << 7;
        }
    }

    static {
        random = new SecureRandom();
        mul = new Tables4kGCMMultiplier();
        exp = new Tables1kGCMExponentiator();
        EMPTY = new byte[0];
        H = new byte[16];
        random.nextBytes(H);
        mul.init(Arrays.clone(H));
        exp.init(Arrays.clone(H));
    }
}

