/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.crypto.generators;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle162.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle162.crypto.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle162.crypto.KeyGenerationParameters;
import org.bouncycastle162.crypto.params.DSAKeyGenerationParameters;
import org.bouncycastle162.crypto.params.DSAParameters;
import org.bouncycastle162.crypto.params.DSAPrivateKeyParameters;
import org.bouncycastle162.crypto.params.DSAPublicKeyParameters;
import org.bouncycastle162.math.ec.WNafUtil;
import org.bouncycastle162.util.BigIntegers;

public class DSAKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private DSAKeyGenerationParameters param;

    public void init(KeyGenerationParameters param) {
        this.param = (DSAKeyGenerationParameters)param;
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        DSAParameters dsaParams = this.param.getParameters();
        BigInteger x = DSAKeyPairGenerator.generatePrivateKey(dsaParams.getQ(), this.param.getRandom());
        BigInteger y = DSAKeyPairGenerator.calculatePublicKey(dsaParams.getP(), dsaParams.getG(), x);
        return new AsymmetricCipherKeyPair(new DSAPublicKeyParameters(y, dsaParams), new DSAPrivateKeyParameters(x, dsaParams));
    }

    private static BigInteger generatePrivateKey(BigInteger q, SecureRandom random) {
        BigInteger x;
        int minWeight = q.bitLength() >>> 2;
        while (WNafUtil.getNafWeight(x = BigIntegers.createRandomInRange(ONE, q.subtract(ONE), random)) < minWeight) {
        }
        return x;
    }

    private static BigInteger calculatePublicKey(BigInteger p, BigInteger g, BigInteger x) {
        return g.modPow(x, p);
    }
}

