/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.cms;

import java.io.IOException;
import org.bouncycastle162.asn1.cms.KEKIdentifier;
import org.bouncycastle162.asn1.cms.KEKRecipientInfo;
import org.bouncycastle162.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle162.cms.AuthAttributesProvider;
import org.bouncycastle162.cms.CMSException;
import org.bouncycastle162.cms.CMSSecureReadable;
import org.bouncycastle162.cms.KEKRecipient;
import org.bouncycastle162.cms.KEKRecipientId;
import org.bouncycastle162.cms.Recipient;
import org.bouncycastle162.cms.RecipientInformation;
import org.bouncycastle162.cms.RecipientOperator;

public class KEKRecipientInformation
extends RecipientInformation {
    private KEKRecipientInfo info;

    KEKRecipientInformation(KEKRecipientInfo info, AlgorithmIdentifier messageAlgorithm, CMSSecureReadable secureReadable, AuthAttributesProvider additionalData) {
        super(info.getKeyEncryptionAlgorithm(), messageAlgorithm, secureReadable, additionalData);
        this.info = info;
        KEKIdentifier kekId = info.getKekid();
        this.rid = new KEKRecipientId(kekId.getKeyIdentifier().getOctets());
    }

    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException, IOException {
        return ((KEKRecipient)recipient).getRecipientOperator(this.keyEncAlg, this.messageAlgorithm, this.info.getEncryptedKey().getOctets());
    }
}

