/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.asn1.test;

import org.bouncycastle162.asn1.ASN1ObjectIdentifier;
import org.bouncycastle162.util.test.SimpleTest;
import org.bouncycastle162.util.test.TestResult;

public class ObjectIdentifierTest
extends SimpleTest {
    public String getName() {
        return "ObjectIdentifier";
    }

    public void performTest() throws Exception {
        ASN1ObjectIdentifier oid3;
        byte[] encoded1;
        ASN1ObjectIdentifier oid2;
        ASN1ObjectIdentifier oid1;
        int j;
        int i;
        for (i = 0; i < 100; ++i) {
            for (j = 0; j < 100; ++j) {
                byte[] encoded2;
                ASN1ObjectIdentifier oid4;
                oid1 = new ASN1ObjectIdentifier("1.1." + i + "." + j);
                if (oid1 == (oid2 = ASN1ObjectIdentifier.getInstance(encoded1 = oid1.getEncoded()))) {
                    this.fail("Shouldn't be the same: " + oid1 + " " + oid2);
                }
                if (!oid1.equals(oid2)) {
                    this.fail("Should be equal: " + oid1 + " " + oid2);
                }
                if (oid2 != (oid3 = oid2.intern())) {
                    this.fail("Should be the same: " + oid2 + " " + oid3);
                }
                if (!oid2.equals(oid3)) {
                    this.fail("Should be equal: " + oid2 + " " + oid3);
                }
                if (oid3 != (oid4 = ASN1ObjectIdentifier.getInstance(encoded2 = oid3.getEncoded()))) {
                    this.fail("Should be taken from cache: " + oid3 + " " + oid4);
                }
                if (oid3.equals(oid4)) continue;
                this.fail("Should be equal: " + oid3 + " " + oid4);
            }
        }
        for (i = 0; i < 100; ++i) {
            for (j = 0; j < 100; ++j) {
                oid1 = new ASN1ObjectIdentifier("1.1.2." + i + "." + j);
                encoded1 = oid1.getEncoded();
                oid2 = ASN1ObjectIdentifier.getInstance(encoded1);
                oid3 = ASN1ObjectIdentifier.getInstance(encoded1);
                if (oid1 == oid2) {
                    this.fail("Shouldn't be the same: " + oid1 + " " + oid2);
                }
                if (oid2 != oid3) continue;
                this.fail("Shouldn't be the same: " + oid2 + " " + oid3);
            }
        }
    }

    public static void main(String[] args) {
        ObjectIdentifierTest test = new ObjectIdentifierTest();
        TestResult result = test.perform();
        System.out.println(result);
    }
}

