/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.jce.provider.test;

import xjyb.org.bjca.asn1.DEROctetString;
import xjyb.org.bjca.asn1.DERSequence;
import xjyb.org.bjca.asn1.x509.GeneralName;
import xjyb.org.bjca.asn1.x509.GeneralSubtree;
import xjyb.org.bjca.jce.provider.PKIXNameConstraintValidator;
import xjyb.org.bjca.jce.provider.PKIXNameConstraintValidatorException;
import xjyb.org.bjca.util.test.SimpleTest;

public class PKIXNameConstraintsTest
extends SimpleTest {
    private static final String testEmail = "test@abc.test.com";
    private static final String[] testEmailIsConstraint = new String[]{"test@abc.test.com", "abc.test.com", ".test.com"};
    private static final String[] testEmailIsNotConstraint = new String[]{".abc.test.com", "www.test.com", "test1@abc.test.com", "bc.test.com"};
    private static final String[] email1 = new String[]{"test@test.com", "test@test.com", "test@test.com", "test@abc.test.com", "test@test.com", "test@test.com", ".test.com", ".test.com", ".test.com", ".test.com", "test.com", "abc.test.com", "abc.test1.com", "test.com", "test.com", ".test.com"};
    private static final String[] email2 = new String[]{"test@test.abc.com", "test@test.com", ".test.com", ".test.com", "test.com", "test1.com", "test@test.com", ".test.com", ".test1.com", "test.com", "test.com", ".test.com", ".test.com", "test1.com", ".test.com", "abc.test.com"};
    private static final String[] emailintersect = new String[]{null, "test@test.com", null, "test@abc.test.com", "test@test.com", null, null, ".test.com", null, null, "test.com", "abc.test.com", null, null, null, "abc.test.com"};
    private static final String[][] emailunion = new String[][]{{"test@test.com", "test@test.abc.com"}, {"test@test.com"}, {"test@test.com", ".test.com"}, {".test.com"}, {"test.com"}, {"test@test.com", "test1.com"}, {".test.com", "test@test.com"}, {".test.com"}, {".test.com", ".test1.com"}, {".test.com", "test.com"}, {"test.com"}, {".test.com"}, {".test.com", "abc.test1.com"}, {"test1.com", "test.com"}, {".test.com", "test.com"}, {".test.com"}};
    private static final String[] dn1 = new String[]{"O=test org, OU=test org unit, CN=John Doe"};
    private static final String[] dn2 = new String[]{"O=test org, OU=test org unit"};
    private static final String[][] dnUnion = new String[][]{{"O=test org, OU=test org unit"}};
    private static final String[] dnIntersection = new String[]{"O=test org, OU=test org unit, CN=John Doe"};
    private static final String testDN = "O=test org, OU=test org unit, CN=John Doe";
    private static final String[] testDNIsConstraint = new String[]{"O=test org, OU=test org unit", "O=test org, OU=test org unit, CN=John Doe"};
    private static final String[] testDNIsNotConstraint = new String[]{"O=test org, OU=test org unit, CN=John Doe2", "O=test org, OU=test org unit2", "OU=test org unit, O=test org, CN=John Doe", "O=test org, OU=test org unit, CN=John Doe, L=USA"};
    private static final String testDNS = "abc.test.com";
    private static final String[] testDNSIsConstraint = new String[]{"test.com", "abc.test.com", "test.com"};
    private static final String[] testDNSIsNotConstraint = new String[]{"wwww.test.com", "ww.test.com", "www.test.com"};
    private static final String[] dns1 = new String[]{"www.test.de", "www.test1.de", "www.test.de"};
    private static final String[] dns2 = new String[]{"test.de", "www.test.de", "www.test.de"};
    private static final String[] dnsintersect = new String[]{"www.test.de", null, null};
    private static final String[][] dnsunion = new String[][]{{"test.de"}, {"www.test1.de", "www.test.de"}, {"www.test.de"}};
    private static final String testURI = "http://karsten:password@abc.test.com:8080";
    private static final String[] testURIIsConstraint = new String[]{"abc.test.com", ".test.com"};
    private static final String[] testURIIsNotConstraint = new String[]{"xyz.test.com", ".abc.test.com"};
    private static final String[] uri1 = new String[]{"www.test.de", ".test.de", "test1.de", ".test.de"};
    private static final String[] uri2 = new String[]{"test.de", "www.test.de", "test1.de", ".test.de"};
    private static final String[] uriintersect = new String[]{null, "www.test.de", "test1.de", ".test.de"};
    private static final String[][] uriunion = new String[][]{{"www.test.de", "test.de"}, {".test.de"}, {"test1.de"}, {".test.de"}};
    private static final byte[] testIP = new byte[]{-64, -88, 1, 2};
    private static final byte[][] testIPIsConstraint = new byte[][]{{-64, -88, 1, 1, -1, -1, -1, 0}, {-64, -88, 1, 1, -1, -1, -1, 4}};
    private static final byte[][] testIPIsNotConstraint = new byte[][]{{-64, -88, 3, 1, -1, -1, -1, 2}, {-64, -88, 1, 1, -1, -1, -1, 3}};
    private static final byte[][] ip1 = new byte[][]{{-64, -88, 1, 1, -1, -1, -2, -1}, {-64, -88, 1, 1, -1, -1, -1, -1}, {-64, -88, 1, 1, -1, -1, -1, 0}};
    private static final byte[][] ip2 = new byte[][]{{-64, -88, 0, 1, -1, -1, -4, 3}, {-64, -88, 1, 1, -1, -1, -1, -1}, {-64, -88, 0, 1, -1, -1, -1, 0}};
    private static final byte[][] ipintersect = new byte[][]{{-64, -88, 0, 1, -1, -1, -2, -1}, {-64, -88, 1, 1, -1, -1, -1, -1}, null};
    private static final byte[][][] ipunion = new byte[][][]{new byte[][]{{-64, -88, 1, 1, -1, -1, -2, -1}, {-64, -88, 0, 1, -1, -1, -4, 3}}, new byte[][]{{-64, -88, 1, 1, -1, -1, -1, -1}}, new byte[][]{{-64, -88, 1, 1, -1, -1, -1, 0}, {-64, -88, 0, 1, -1, -1, -1, 0}}};

    @Override
    public String getName() {
        return "PKIXNameConstraintsTest";
    }

    @Override
    public void performTest() throws Exception {
        this.testConstraints(1, testEmail, testEmailIsConstraint, testEmailIsNotConstraint, email1, email2, emailunion, emailintersect);
        this.testConstraints(2, testDNS, testDNSIsConstraint, testDNSIsNotConstraint, dns1, dns2, dnsunion, dnsintersect);
        this.testConstraints(4, testDN, testDNIsConstraint, testDNIsNotConstraint, dn1, dn2, dnUnion, dnIntersection);
        this.testConstraints(6, testURI, testURIIsConstraint, testURIIsNotConstraint, uri1, uri2, uriunion, uriintersect);
        this.testConstraints(7, testIP, testIPIsConstraint, testIPIsNotConstraint, ip1, ip2, ipunion, ipintersect);
    }

    private void testConstraints(int nameType, String testName, String[] testNameIsConstraint, String[] testNameIsNotConstraint, String[] testNames1, String[] testNames2, String[][] testUnion, String[] testInterSection) throws Exception {
        PKIXNameConstraintValidator constraintValidator;
        int i;
        for (i = 0; i < testNameIsConstraint.length; ++i) {
            constraintValidator = new PKIXNameConstraintValidator();
            constraintValidator.intersectPermittedSubtree(new DERSequence(new GeneralSubtree(new GeneralName(nameType, testNameIsConstraint[i]))));
            constraintValidator.checkPermitted(new GeneralName(nameType, testName));
        }
        for (i = 0; i < testNameIsNotConstraint.length; ++i) {
            constraintValidator = new PKIXNameConstraintValidator();
            constraintValidator.intersectPermittedSubtree(new DERSequence(new GeneralSubtree(new GeneralName(nameType, testNameIsNotConstraint[i]))));
            try {
                constraintValidator.checkPermitted(new GeneralName(nameType, testName));
                this.fail("not permitted name allowed: " + nameType);
                continue;
            }
            catch (PKIXNameConstraintValidatorException e) {
                // empty catch block
            }
        }
        for (i = 0; i < testNameIsConstraint.length; ++i) {
            constraintValidator = new PKIXNameConstraintValidator();
            constraintValidator.addExcludedSubtree(new GeneralSubtree(new GeneralName(nameType, testNameIsConstraint[i])));
            try {
                constraintValidator.checkExcluded(new GeneralName(nameType, testName));
                this.fail("excluded name missed: " + nameType);
                continue;
            }
            catch (PKIXNameConstraintValidatorException e) {
                // empty catch block
            }
        }
        for (i = 0; i < testNameIsNotConstraint.length; ++i) {
            constraintValidator = new PKIXNameConstraintValidator();
            constraintValidator.addExcludedSubtree(new GeneralSubtree(new GeneralName(nameType, testNameIsNotConstraint[i])));
            constraintValidator.checkExcluded(new GeneralName(nameType, testName));
        }
        for (i = 0; i < testNames1.length; ++i) {
            constraintValidator = new PKIXNameConstraintValidator();
            constraintValidator.addExcludedSubtree(new GeneralSubtree(new GeneralName(nameType, testNames1[i])));
            constraintValidator.addExcludedSubtree(new GeneralSubtree(new GeneralName(nameType, testNames2[i])));
            PKIXNameConstraintValidator constraints2 = new PKIXNameConstraintValidator();
            for (int j = 0; j < testUnion[i].length; ++j) {
                constraints2.addExcludedSubtree(new GeneralSubtree(new GeneralName(nameType, testUnion[i][j])));
            }
            if (!constraints2.equals(constraintValidator)) {
                this.fail("union wrong: " + nameType);
            }
            constraintValidator = new PKIXNameConstraintValidator();
            constraintValidator.intersectPermittedSubtree(new DERSequence(new GeneralSubtree(new GeneralName(nameType, testNames1[i]))));
            constraintValidator.intersectPermittedSubtree(new DERSequence(new GeneralSubtree(new GeneralName(nameType, testNames2[i]))));
            constraints2 = new PKIXNameConstraintValidator();
            if (testInterSection[i] != null) {
                constraints2.intersectPermittedSubtree(new DERSequence(new GeneralSubtree(new GeneralName(nameType, testInterSection[i]))));
            } else {
                constraints2.intersectEmptyPermittedSubtree(nameType);
            }
            if (constraints2.equals(constraintValidator)) continue;
            this.fail("intersection wrong: " + nameType);
        }
    }

    private void testConstraints(int nameType, byte[] testName, byte[][] testNameIsConstraint, byte[][] testNameIsNotConstraint, byte[][] testNames1, byte[][] testNames2, byte[][][] testUnion, byte[][] testInterSection) throws Exception {
        PKIXNameConstraintValidator constraintValidator;
        int i;
        for (i = 0; i < testNameIsConstraint.length; ++i) {
            constraintValidator = new PKIXNameConstraintValidator();
            constraintValidator.intersectPermittedSubtree(new DERSequence(new GeneralSubtree(new GeneralName(nameType, new DEROctetString(testNameIsConstraint[i])))));
            constraintValidator.checkPermitted(new GeneralName(nameType, new DEROctetString(testName)));
        }
        for (i = 0; i < testNameIsNotConstraint.length; ++i) {
            constraintValidator = new PKIXNameConstraintValidator();
            constraintValidator.intersectPermittedSubtree(new DERSequence(new GeneralSubtree(new GeneralName(nameType, new DEROctetString(testNameIsNotConstraint[i])))));
            try {
                constraintValidator.checkPermitted(new GeneralName(nameType, new DEROctetString(testName)));
                this.fail("not permitted name allowed: " + nameType);
                continue;
            }
            catch (PKIXNameConstraintValidatorException e) {
                // empty catch block
            }
        }
        for (i = 0; i < testNameIsConstraint.length; ++i) {
            constraintValidator = new PKIXNameConstraintValidator();
            constraintValidator.addExcludedSubtree(new GeneralSubtree(new GeneralName(nameType, new DEROctetString(testNameIsConstraint[i]))));
            try {
                constraintValidator.checkExcluded(new GeneralName(nameType, new DEROctetString(testName)));
                this.fail("excluded name missed: " + nameType);
                continue;
            }
            catch (PKIXNameConstraintValidatorException e) {
                // empty catch block
            }
        }
        for (i = 0; i < testNameIsNotConstraint.length; ++i) {
            constraintValidator = new PKIXNameConstraintValidator();
            constraintValidator.addExcludedSubtree(new GeneralSubtree(new GeneralName(nameType, new DEROctetString(testNameIsNotConstraint[i]))));
            constraintValidator.checkExcluded(new GeneralName(nameType, new DEROctetString(testName)));
        }
        for (i = 0; i < testNames1.length; ++i) {
            constraintValidator = new PKIXNameConstraintValidator();
            constraintValidator.addExcludedSubtree(new GeneralSubtree(new GeneralName(nameType, new DEROctetString(testNames1[i]))));
            constraintValidator.addExcludedSubtree(new GeneralSubtree(new GeneralName(nameType, new DEROctetString(testNames2[i]))));
            PKIXNameConstraintValidator constraints2 = new PKIXNameConstraintValidator();
            for (int j = 0; j < testUnion[i].length; ++j) {
                constraints2.addExcludedSubtree(new GeneralSubtree(new GeneralName(nameType, new DEROctetString(testUnion[i][j]))));
            }
            if (!constraints2.equals(constraintValidator)) {
                this.fail("union wrong: " + nameType);
            }
            constraintValidator = new PKIXNameConstraintValidator();
            constraintValidator.intersectPermittedSubtree(new DERSequence(new GeneralSubtree(new GeneralName(nameType, new DEROctetString(testNames1[i])))));
            constraintValidator.intersectPermittedSubtree(new DERSequence(new GeneralSubtree(new GeneralName(nameType, new DEROctetString(testNames2[i])))));
            constraints2 = new PKIXNameConstraintValidator();
            if (testInterSection[i] != null) {
                constraints2.intersectPermittedSubtree(new DERSequence(new GeneralSubtree(new GeneralName(nameType, new DEROctetString(testInterSection[i])))));
            } else {
                constraints2.intersectEmptyPermittedSubtree(nameType);
            }
            if (constraints2.equals(constraintValidator)) continue;
            this.fail("intersection wrong: " + nameType);
        }
    }

    public static void main(String[] args) {
        PKIXNameConstraintsTest.runTest(new PKIXNameConstraintsTest());
    }
}

