/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.jce.provider.asymmetric.ec;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Hashtable;
import xjyb.org.bjca.crypto.AsymmetricCipherKeyPair;
import xjyb.org.bjca.crypto.generators.ECKeyPairGenerator;
import xjyb.org.bjca.crypto.params.ECDomainParameters;
import xjyb.org.bjca.crypto.params.ECKeyGenerationParameters;
import xjyb.org.bjca.crypto.params.ECPrivateKeyParameters;
import xjyb.org.bjca.crypto.params.ECPublicKeyParameters;
import xjyb.org.bjca.jce.ECNamedCurveTable;
import xjyb.org.bjca.jce.provider.JCEECPrivateKey;
import xjyb.org.bjca.jce.provider.JCEECPublicKey;
import xjyb.org.bjca.jce.provider.JDKKeyPairGenerator;
import xjyb.org.bjca.jce.provider.ProviderUtil;
import xjyb.org.bjca.jce.spec.ECParameterSpec;

public abstract class KeyPairGenerator
extends JDKKeyPairGenerator {
    public KeyPairGenerator(String algorithmName) {
        super(algorithmName);
    }

    public static class ECDHC
    extends EC {
        public ECDHC() {
            super("ECDHC");
        }
    }

    public static class ECDH
    extends EC {
        public ECDH() {
            super("ECDH");
        }
    }

    public static class ECGOST3410
    extends EC {
        public ECGOST3410() {
            super("ECGOST3410");
        }
    }

    public static class ECDSA
    extends EC {
        public ECDSA() {
            super("ECDSA");
        }
    }

    public static class EC
    extends KeyPairGenerator {
        ECKeyGenerationParameters param;
        ECKeyPairGenerator engine = new ECKeyPairGenerator();
        ECParameterSpec ecParams = null;
        int strength = 239;
        int certainty = 50;
        SecureRandom random = new SecureRandom();
        boolean initialised = false;
        String algorithm;
        private static Hashtable ecParameters = new Hashtable();

        public EC() {
            super("EC");
            this.algorithm = "EC";
        }

        public EC(String algorithm) {
            super(algorithm);
            this.algorithm = algorithm;
        }

        @Override
        public void initialize(int strength, SecureRandom random) {
            this.strength = strength;
            this.random = random;
            this.ecParams = (ECParameterSpec)ecParameters.get(new Integer(strength));
            if (this.ecParams == null) {
                throw new InvalidParameterException("unknown key size.");
            }
            this.param = new ECKeyGenerationParameters(new ECDomainParameters(this.ecParams.getCurve(), this.ecParams.getG(), this.ecParams.getN()), random);
            this.engine.init(this.param);
            this.initialised = true;
        }

        @Override
        public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
            if (params instanceof ECParameterSpec) {
                ECParameterSpec p = (ECParameterSpec)params;
                this.ecParams = (ECParameterSpec)params;
                this.param = new ECKeyGenerationParameters(new ECDomainParameters(p.getCurve(), p.getG(), p.getN()), random);
                this.engine.init(this.param);
                this.initialised = true;
            } else if (params == null && ProviderUtil.getEcImplicitlyCa() != null) {
                ECParameterSpec p = ProviderUtil.getEcImplicitlyCa();
                this.ecParams = (ECParameterSpec)params;
                this.param = new ECKeyGenerationParameters(new ECDomainParameters(p.getCurve(), p.getG(), p.getN()), random);
                this.engine.init(this.param);
                this.initialised = true;
            } else {
                if (params == null && ProviderUtil.getEcImplicitlyCa() == null) {
                    throw new InvalidAlgorithmParameterException("null parameter passed but no implicitCA set");
                }
                throw new InvalidAlgorithmParameterException("parameter object not a ECParameterSpec");
            }
        }

        @Override
        public KeyPair generateKeyPair() {
            if (!this.initialised) {
                throw new IllegalStateException("EC Key Pair Generator not initialised");
            }
            AsymmetricCipherKeyPair pair = this.engine.generateKeyPair();
            ECPublicKeyParameters pub = (ECPublicKeyParameters)pair.getPublic();
            ECPrivateKeyParameters priv = (ECPrivateKeyParameters)pair.getPrivate();
            if (this.ecParams == null) {
                return new KeyPair(new JCEECPublicKey(this.algorithm, pub), new JCEECPrivateKey(this.algorithm, priv));
            }
            ECParameterSpec p = this.ecParams;
            return new KeyPair(new JCEECPublicKey(this.algorithm, pub, p), new JCEECPrivateKey(this.algorithm, priv, p));
        }

        static {
            ecParameters.put(new Integer(192), ECNamedCurveTable.getParameterSpec("prime192v1"));
            ecParameters.put(new Integer(239), ECNamedCurveTable.getParameterSpec("prime239v1"));
            ecParameters.put(new Integer(256), ECNamedCurveTable.getParameterSpec("prime256v1"));
        }
    }
}

