/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.apache.http.protocol;

import java.io.IOException;
import xjyb.org.apache.http.HttpEntityEnclosingRequest;
import xjyb.org.apache.http.HttpException;
import xjyb.org.apache.http.HttpRequest;
import xjyb.org.apache.http.HttpRequestInterceptor;
import xjyb.org.apache.http.annotation.Contract;
import xjyb.org.apache.http.annotation.ThreadingBehavior;
import xjyb.org.apache.http.protocol.HttpContext;
import xjyb.org.apache.http.protocol.HttpDateGenerator;
import xjyb.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.SAFE)
public class RequestDate
implements HttpRequestInterceptor {
    private static final HttpDateGenerator DATE_GENERATOR = new HttpDateGenerator();

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (request instanceof HttpEntityEnclosingRequest && !request.containsHeader("Date")) {
            String httpdate = DATE_GENERATOR.getCurrentDate();
            request.setHeader("Date", httpdate);
        }
    }
}

