/*
 * Decompiled with CFR 0.152.
 */
package com.uccs;

import com.xjyb.ca.SecureService;
import com.xjyb.ca.sansec.SansecCertificateConfig;
import com.xjyb.ca.sansec.SansecSecureServiceImpl;
import com.xjyb.config.PasswordServiceConfig;

class SecureServiceFactory {
    SecureServiceFactory() {
    }

    protected static final SecureService getSecureService(String ca) {
        switch (ca) {
            case "3": {
                return SecureServiceFactory.createSansecSecureService();
            }
        }
        throw new IllegalArgumentException("\u4e0d\u5b58\u5728\u7684\u8bc1\u4e66\u673a\u6784\uff1a" + ca);
    }

    private static SecureService createSansecSecureService() {
        PasswordServiceConfig config = PasswordServiceConfig.getInstance();
        String certSessionPath = config.getCerturl() + config.getCertSessionName();
        String certPrePath = "";
        String certEncryptPath = "";
        if (config.getCerturl().equals("classpath/") || config.getCerturl().equals("classpath\\")) {
            certPrePath = config.getCertPreName();
            certEncryptPath = config.getCertEncryptName();
        } else {
            certPrePath = config.getCerturl() + config.getCertPreName();
            certEncryptPath = config.getCerturl() + config.getCertEncryptName();
        }
        SansecCertificateConfig certificateConfig = new SansecCertificateConfig(certPrePath, config.getCertPreKey(), certSessionPath, config.getCertSessionKey(), certEncryptPath, config.getCertEncryptKey());
        return new SansecSecureServiceImpl(certificateConfig);
    }
}

