/*
 * Decompiled with CFR 0.152.
 */
package com.uccs;

import com.xjyb.ca.SecureService;
import com.xjyb.util.SecureCommonUtil;
import java.util.Base64;
import xjyb.com.alibaba.fastjson.JSONObject;

class KeyInfo {
    protected static final String KEYVERSION = "keyVersion";
    protected static final String KEYBLOB = "keyBlob";
    protected static final int UPDATE_INTERVAL = 30000;
    private final String keyVersion;
    private volatile boolean expired = false;
    private volatile long updateLine;
    private final long lastUpdateTime;
    private final byte[] masterKey;

    private KeyInfo(String keyVersion, byte[] keyBlob) {
        this.keyVersion = keyVersion;
        this.masterKey = keyBlob;
        SecureCommonUtil.requireNonNull(keyVersion, "\u5bc6\u94a5\u7248\u672c\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        long now = System.currentTimeMillis();
        this.updateLine = now + 30000L;
        this.lastUpdateTime = now;
    }

    public void callBussiness() {
        this.updateLine = System.currentTimeMillis() + 30000L;
    }

    public boolean isNeedUpdateKey() {
        return this.updateLine < System.currentTimeMillis();
    }

    public boolean isNeedForceUpdateKey() {
        return this.lastUpdateTime + 28800000L < System.currentTimeMillis();
    }

    protected boolean isExpired() {
        return this.expired;
    }

    protected void expire() {
        this.expired = true;
    }

    protected String getKeyVersion() {
        return this.keyVersion;
    }

    public byte[] getMasterKey() {
        return this.masterKey;
    }

    protected static KeyInfo create(String keys, SecureService secureService) {
        JSONObject jsonObject = JSONObject.parseObject(keys);
        String keyVersion = jsonObject.getString(KEYVERSION);
        String keyBlob = jsonObject.getString(KEYBLOB);
        System.out.println("\u3010keyVersion\u3011\uff1a" + keyVersion);
        System.out.println("\u3010keyBlob\u3011\uff1a" + keyBlob);
        byte[] keyBlobBytes = Base64.getDecoder().decode(keyBlob);
        byte[] master_group_encoded = secureService.decryptKeyBLob(keyBlobBytes);
        KeyInfo keyInfo = new KeyInfo(keyVersion, master_group_encoded);
        return keyInfo;
    }
}

