/*
 * Decompiled with CFR 0.152.
 */
package com.uccs;

import com.uccs.KeyInfo;
import com.uccs.SecureServiceFactory;
import com.xjyb.ca.SecureService;
import com.xjyb.config.PasswordServiceConfig;
import com.xjyb.exception.SecureException;
import com.xjyb.exception.SecureKeyInvalidException;

final class AppContext {
    private static final int KEY_UNINITIALIZED = 0;
    private static final int KEY_RUNNING = 1;
    private static final int KEY_UPDATING = 2;
    private volatile KeyInfo currKey = null;
    private volatile SecureService secureService;
    private volatile boolean isitialized = false;
    private volatile int currKeyState = 0;
    private Object keyLock = new Object();

    private AppContext() {
        this.initSecureSevice();
    }

    private synchronized void initSecureSevice() throws SecureException {
        if (!this.isitialized) {
            String caAgency = PasswordServiceConfig.getInstance().getCaAgency();
            this.secureService = SecureServiceFactory.getSecureService(caAgency);
            this.isitialized = true;
        }
    }

    KeyInfo getCurrKey() {
        if (this.currKey == null || this.currKey.isExpired()) {
            throw new SecureKeyInvalidException("\u5bc6\u94a5\u8fd8\u6ca1\u521d\u59cb\u5316\u6216\u8005\u5bc6\u94a5\u5df2\u7ecf\u8fc7\u671f\uff0c\u8bf7\u5148\u7533\u8bf7\u5bc6\u94a5\uff01");
        }
        return this.currKey;
    }

    boolean isCurrentKeyExpired() {
        return this.currKey.isExpired();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateCurrentKey(KeyInfo secureKey) {
        Object object = this.keyLock;
        synchronized (object) {
            this.currKey = secureKey;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initCurrentKey(KeyInfo secureKey) {
        Object object = this.keyLock;
        synchronized (object) {
            this.currKey = secureKey;
            this.currKeyState = 1;
        }
    }

    public SecureService getSecureService() {
        return this.secureService;
    }

    public static final AppContext getInstance() {
        return Holder.INSTANCE;
    }

    protected boolean isCurrKeyUninitialized() {
        return this.currKey == null;
    }

    protected boolean isCurrKeyRunning() {
        return this.currKeyState == 1;
    }

    protected boolean isCurrKeyUpdating() {
        return this.currKeyState == 2;
    }

    protected void startUpdateCurrKey() {
        this.currKeyState = 2;
    }

    public void endUpdateCurrKey() {
        this.currKeyState = 1;
    }

    private static class Holder {
        private static final AppContext INSTANCE = new AppContext();

        private Holder() {
        }
    }
}

