/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.pkix;

import cn.org.bjca.gaia.asn1.pkcs.PrivateKeyInfo;
import cn.org.bjca.gaia.asn1.x509.SubjectKeyIdentifier;
import cn.org.bjca.gaia.cert.X509CertificateHolder;
import cn.org.bjca.gaia.cms.KeyTransRecipientId;
import cn.org.bjca.gaia.cms.RecipientId;

public class PKIXIdentity {
    private final PrivateKeyInfo privateKeyInfo;
    private final X509CertificateHolder[] certificateHolders;

    public PKIXIdentity(PrivateKeyInfo privateKeyInfo, X509CertificateHolder[] certificateHolders) {
        this.privateKeyInfo = privateKeyInfo;
        this.certificateHolders = new X509CertificateHolder[certificateHolders.length];
        System.arraycopy(certificateHolders, 0, this.certificateHolders, 0, certificateHolders.length);
    }

    public PrivateKeyInfo getPrivateKeyInfo() {
        return this.privateKeyInfo;
    }

    public X509CertificateHolder getCertificate() {
        return this.certificateHolders[0];
    }

    public RecipientId getRecipientId() {
        return new KeyTransRecipientId(this.certificateHolders[0].getIssuer(), this.certificateHolders[0].getSerialNumber(), this.getSubjectKeyIdentifier());
    }

    private byte[] getSubjectKeyIdentifier() {
        SubjectKeyIdentifier subId = SubjectKeyIdentifier.fromExtensions(this.certificateHolders[0].getExtensions());
        if (subId == null) {
            return null;
        }
        return subId.getKeyIdentifier();
    }
}

