/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.pkcs.jcajce;

import cn.org.bjca.gaia.asn1.ASN1ObjectIdentifier;
import cn.org.bjca.gaia.asn1.cryptopro.CryptoProObjectIdentifiers;
import cn.org.bjca.gaia.asn1.nist.NISTObjectIdentifiers;
import cn.org.bjca.gaia.asn1.pkcs.PKCSObjectIdentifiers;
import java.util.HashMap;
import java.util.Map;

class JceUtils {
    private static final Map PRFS = new HashMap();

    JceUtils() {
    }

    static String getAlgorithm(ASN1ObjectIdentifier algorithm) {
        if (!PRFS.containsKey(algorithm)) {
            throw new IllegalStateException("no prf for algorithm: " + algorithm);
        }
        return (String)PRFS.get(algorithm);
    }

    static {
        PRFS.put(PKCSObjectIdentifiers.id_hmacWithSHA1, "PBKDF2withHMACSHA1");
        PRFS.put(PKCSObjectIdentifiers.id_hmacWithSHA256, "PBKDF2withHMACSHA256");
        PRFS.put(PKCSObjectIdentifiers.id_hmacWithSHA512, "PBKDF2withHMACSHA512");
        PRFS.put(PKCSObjectIdentifiers.id_hmacWithSHA224, "PBKDF2withHMACSHA224");
        PRFS.put(PKCSObjectIdentifiers.id_hmacWithSHA384, "PBKDF2withHMACSHA384");
        PRFS.put(NISTObjectIdentifiers.id_hmacWithSHA3_224, "PBKDF2withHMACSHA3-224");
        PRFS.put(NISTObjectIdentifiers.id_hmacWithSHA3_256, "PBKDF2withHMACSHA3-256");
        PRFS.put(NISTObjectIdentifiers.id_hmacWithSHA3_384, "PBKDF2withHMACSHA3-384");
        PRFS.put(NISTObjectIdentifiers.id_hmacWithSHA3_512, "PBKDF2withHMACSHA3-512");
        PRFS.put(CryptoProObjectIdentifiers.gostR3411Hmac, "PBKDF2withHMACGOST3411");
    }
}

